package ai.foremast.metrics.k8s.starter;

import javax.servlet.*;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * K8s use /metrics and prometheus format metrics description by default
 * So "/metrics" needs to be pointed to "/actuator/prometheus"
 */
public class K8sMetricsFilter implements Filter {
    @Override
    public void init(FilterConfig filterConfig) {
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletResponse instanceof HttpServletResponse) {
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            response.sendRedirect("/actuator/prometheus");
        }
        else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    @Override
    public void destroy() {

    }
}
