/*
 * Decompiled with CFR 0.152.
 */
package ai.foremast.micrometer.web.servlet;

import ai.foremast.micrometer.TimedUtils;
import ai.foremast.micrometer.web.servlet.HandlerMappingIntrospector;
import ai.foremast.micrometer.web.servlet.WebMvcTagsProvider;
import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.lang.NonNullApi;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.util.NestedServletException;

@NonNullApi
@Order(value=-2147483647)
public class WebMvcMetricsFilter
extends OncePerRequestFilter {
    private static final String TIMING_SAMPLE = "micrometer.timingSample";
    private static final Log logger = LogFactory.getLog(WebMvcMetricsFilter.class);
    private final MeterRegistry registry;
    private final WebMvcTagsProvider tagsProvider;
    private final String metricName;
    private final boolean autoTimeRequests;
    private final HandlerMappingIntrospector mappingIntrospector;

    public WebMvcMetricsFilter(MeterRegistry registry, WebMvcTagsProvider tagsProvider, String metricName, boolean autoTimeRequests, HandlerMappingIntrospector mappingIntrospector) {
        this.registry = registry;
        this.tagsProvider = tagsProvider;
        this.metricName = metricName;
        this.autoTimeRequests = autoTimeRequests;
        this.mappingIntrospector = mappingIntrospector;
    }

    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        HandlerExecutionChain handler = null;
        try {
            handler = this.mappingIntrospector.getHandlerExecutionChain(request);
        }
        catch (Exception e) {
            logger.debug((Object)"Unable to time request", (Throwable)e);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Object handlerObject = handler == null ? null : handler.getHandler();
        TimingSampleContext timingContext = (TimingSampleContext)request.getAttribute(TIMING_SAMPLE);
        if (timingContext == null) {
            timingContext = new TimingSampleContext(request, handlerObject);
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            if (request.isAsyncSupported() && request.isAsyncStarted()) {
                request.setAttribute(TIMING_SAMPLE, (Object)timingContext);
            }
            if (!request.isAsyncStarted()) {
                this.record(timingContext, response, request, handlerObject, (Throwable)request.getAttribute(DispatcherServlet.EXCEPTION_ATTRIBUTE));
            }
        }
        catch (NestedServletException e) {
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            this.record(timingContext, response, request, handlerObject, e.getCause());
            throw e;
        }
    }

    private void record(TimingSampleContext timingContext, HttpServletResponse response, HttpServletRequest request, Object handlerObject, Throwable e) {
        for (Timed timedAnnotation : timingContext.timedAnnotations) {
            timingContext.timerSample.stop(Timer.builder((Timed)timedAnnotation, (String)this.metricName).tags(this.tagsProvider.httpRequestTags(request, response, handlerObject, e)).register(this.registry));
        }
        if (timingContext.timedAnnotations.isEmpty() && this.autoTimeRequests) {
            timingContext.timerSample.stop(Timer.builder((String)this.metricName).tags(this.tagsProvider.httpRequestTags(request, response, handlerObject, e)).register(this.registry));
        }
        for (LongTaskTimer.Sample sample : timingContext.longTaskTimerSamples) {
            sample.stop();
        }
    }

    private class TimingSampleContext {
        private final Set<Timed> timedAnnotations;
        private final Timer.Sample timerSample;
        private final Collection<LongTaskTimer.Sample> longTaskTimerSamples;

        TimingSampleContext(HttpServletRequest request, Object handlerObject) {
            this.timedAnnotations = this.annotations(handlerObject);
            this.timerSample = Timer.start((MeterRegistry)WebMvcMetricsFilter.this.registry);
            this.longTaskTimerSamples = this.timedAnnotations.stream().filter(Timed::longTask).map(t -> LongTaskTimer.builder((Timed)t).tags(WebMvcMetricsFilter.this.tagsProvider.httpLongRequestTags(request, handlerObject)).register(WebMvcMetricsFilter.this.registry).start()).collect(Collectors.toList());
        }

        private Set<Timed> annotations(Object handler) {
            if (handler instanceof HandlerMethod) {
                HandlerMethod handlerMethod = (HandlerMethod)handler;
                Set<Timed> timed = TimedUtils.findTimedAnnotations(handlerMethod.getMethod());
                if (timed.isEmpty()) {
                    return TimedUtils.findTimedAnnotations(handlerMethod.getBeanType());
                }
                return timed;
            }
            return Collections.emptySet();
        }
    }
}

