/*
 * Decompiled with CFR 0.152.
 */
package ai.foremast.micrometer.autoconfigure.web.servlet;

import ai.foremast.micrometer.autoconfigure.MetricsAutoConfiguration;
import ai.foremast.micrometer.autoconfigure.MetricsProperties;
import ai.foremast.micrometer.autoconfigure.OnlyOnceLoggingDenyMeterFilter;
import ai.foremast.micrometer.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import ai.foremast.micrometer.web.servlet.DefaultWebMvcTagsProvider;
import ai.foremast.micrometer.web.servlet.HandlerMappingIntrospector;
import ai.foremast.micrometer.web.servlet.WebMvcMetricsFilter;
import ai.foremast.micrometer.web.servlet.WebMvcTagsProvider;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

@Configuration
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@ConditionalOnWebApplication
@ConditionalOnClass(value={DispatcherServlet.class})
@ConditionalOnBean(value={MeterRegistry.class})
@EnableConfigurationProperties(value={MetricsProperties.class})
public class WebMvcMetricsAutoConfiguration {
    @Autowired
    private MetricsProperties properties;

    @Bean
    @ConditionalOnMissingBean(value={WebMvcTagsProvider.class})
    public DefaultWebMvcTagsProvider servletTagsProvider() {
        return new DefaultWebMvcTagsProvider();
    }

    @Bean
    public WebMvcMetricsFilter webMetricsFilter(MeterRegistry registry, WebMvcTagsProvider tagsProvider, WebApplicationContext ctx) {
        return new WebMvcMetricsFilter(registry, tagsProvider, this.properties.getWeb().getServer().getRequestsMetricName(), this.properties.getWeb().getServer().isAutoTimeRequests(), new HandlerMappingIntrospector((ApplicationContext)ctx));
    }

    @Bean
    @Order(value=0)
    public MeterFilter metricsHttpServerUriTagFilter() {
        String metricName = this.properties.getWeb().getServer().getRequestsMetricName();
        OnlyOnceLoggingDenyMeterFilter filter = new OnlyOnceLoggingDenyMeterFilter(() -> String.format("Reached the maximum number of URI tags for '%s'.", metricName));
        return MeterFilter.maximumAllowableTags((String)metricName, (String)"uri", (int)this.properties.getWeb().getServer().getMaxUriTags(), (MeterFilter)filter);
    }
}

