/*
 * Decompiled with CFR 0.152.
 */
package ai.foremast.micrometer.autoconfigure.export.simple;

import ai.foremast.micrometer.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import ai.foremast.micrometer.autoconfigure.MetricsAutoConfiguration;
import ai.foremast.micrometer.autoconfigure.export.StringToDurationConverter;
import ai.foremast.micrometer.autoconfigure.export.simple.SimpleProperties;
import ai.foremast.micrometer.autoconfigure.export.simple.SimplePropertiesConfigAdapter;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleConfig;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@EnableConfigurationProperties(value={SimpleProperties.class})
@ConditionalOnMissingBean(value={MeterRegistry.class})
@ConditionalOnProperty(prefix="management.metrics.export.simple", name={"enabled"}, havingValue="true", matchIfMissing=true)
@Import(value={StringToDurationConverter.class})
public class SimpleMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={SimpleConfig.class})
    public SimpleConfig simpleRegistryConfig(SimpleProperties props) {
        return new SimplePropertiesConfigAdapter(props);
    }

    @Bean
    @ConditionalOnMissingBean(value={MeterRegistry.class})
    public SimpleMeterRegistry simpleMeterRegistry(SimpleConfig config, Clock clock) {
        return new SimpleMeterRegistry(config, clock);
    }
}

