/*
 * Decompiled with CFR 0.152.
 */
package ai.foremast.micrometer.autoconfigure.export.prometheus;

import ai.foremast.micrometer.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import ai.foremast.micrometer.autoconfigure.MetricsAutoConfiguration;
import ai.foremast.micrometer.autoconfigure.export.StringToDurationConverter;
import ai.foremast.micrometer.autoconfigure.export.prometheus.PrometheusProperties;
import ai.foremast.micrometer.autoconfigure.export.prometheus.PrometheusPropertiesConfigAdapter;
import ai.foremast.micrometer.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import ai.foremast.micrometer.export.prometheus.PrometheusScrapeEndpoint;
import ai.foremast.micrometer.export.prometheus.PrometheusScrapeMvcEndpoint;
import io.micrometer.core.instrument.Clock;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.prometheus.client.CollectorRegistry;
import org.springframework.boot.actuate.autoconfigure.ManagementContextConfiguration;
import org.springframework.boot.actuate.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={PrometheusMeterRegistry.class})
@ConditionalOnProperty(prefix="management.metrics.export.prometheus", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={PrometheusProperties.class})
@Import(value={StringToDurationConverter.class})
public class PrometheusMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={PrometheusConfig.class})
    public PrometheusConfig prometheusConfig(PrometheusProperties props) {
        return new PrometheusPropertiesConfigAdapter(props);
    }

    @Bean
    @ConditionalOnMissingBean(value={PrometheusMeterRegistry.class})
    public PrometheusMeterRegistry prometheusMeterRegistry(PrometheusConfig config, CollectorRegistry collectorRegistry, Clock clock) {
        return new PrometheusMeterRegistry(config, collectorRegistry, clock);
    }

    @Bean
    @ConditionalOnMissingBean(value={CollectorRegistry.class})
    public CollectorRegistry collectorRegistry() {
        return new CollectorRegistry(true);
    }

    @ManagementContextConfiguration
    @ConditionalOnClass(value={AbstractEndpoint.class})
    public static class PrometheusScrapeEndpointConfiguration {
        @Bean
        public PrometheusScrapeEndpoint prometheusEndpoint(CollectorRegistry collectorRegistry) {
            return new PrometheusScrapeEndpoint(collectorRegistry);
        }

        @Bean
        @ConditionalOnEnabledEndpoint(value="prometheus")
        public PrometheusScrapeMvcEndpoint prometheusMvcEndpoint(PrometheusScrapeEndpoint delegate) {
            return new PrometheusScrapeMvcEndpoint(delegate);
        }
    }
}

