/*
 * Decompiled with CFR 0.152.
 */
package ai.foremast.micrometer.autoconfigure;

import ai.foremast.micrometer.autoconfigure.MetricsAutoConfiguration;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnClass(value={MeterRegistry.class})
@ConditionalOnBean(value={MeterRegistry.class})
public class SystemMetricsAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"management.metrics.binders.uptime.enabled"}, matchIfMissing=true)
    @ConditionalOnMissingBean(value={UptimeMetrics.class})
    public UptimeMetrics uptimeMetrics() {
        return new UptimeMetrics();
    }

    @Bean
    @ConditionalOnProperty(value={"management.metrics.binders.processor.enabled"}, matchIfMissing=true)
    @ConditionalOnMissingBean(value={ProcessorMetrics.class})
    public ProcessorMetrics processorMetrics() {
        return new ProcessorMetrics();
    }

    @Bean
    @ConditionalOnProperty(name={"management.metrics.binders.files.enabled"}, matchIfMissing=true)
    @ConditionalOnMissingBean(value={FileDescriptorMetrics.class})
    public FileDescriptorMetrics fileDescriptorMetrics() {
        return new FileDescriptorMetrics();
    }
}

