/*
 * Decompiled with CFR 0.152.
 */
package ai.foremast.micrometer.autoconfigure;

import ai.foremast.micrometer.autoconfigure.MeterValue;
import ai.foremast.micrometer.autoconfigure.MetricsProperties;
import ai.foremast.micrometer.autoconfigure.ServiceLevelAgreementBoundary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.MeterFilterReply;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PropertiesMeterFilter
implements MeterFilter {
    private final MetricsProperties properties;
    private final MeterFilter mapFilter;

    public PropertiesMeterFilter(MetricsProperties properties) {
        Assert.notNull((Object)properties, (String)"Properties must not be null");
        this.properties = properties;
        this.mapFilter = PropertiesMeterFilter.createMapFilter(properties.getTags());
    }

    private static MeterFilter createMapFilter(Map<String, String> tags) {
        if (tags.isEmpty()) {
            return new MeterFilter(){};
        }
        Tags commonTags = Tags.of((Iterable)tags.entrySet().stream().map((? super T entry) -> Tag.of((String)((String)entry.getKey()), (String)((String)entry.getValue()))).collect(Collectors.toList()));
        return MeterFilter.commonTags((Iterable)commonTags);
    }

    public MeterFilterReply accept(Meter.Id id) {
        boolean enabled = this.lookupWithFallbackToAll(this.properties.getEnable(), id, true);
        return enabled ? MeterFilterReply.NEUTRAL : MeterFilterReply.DENY;
    }

    public Meter.Id map(Meter.Id id) {
        return this.mapFilter.map(id);
    }

    public DistributionStatisticConfig configure(Meter.Id id, DistributionStatisticConfig config) {
        MetricsProperties.Distribution distribution = this.properties.getDistribution();
        return DistributionStatisticConfig.builder().percentilesHistogram((Boolean)this.lookupWithFallbackToAll(distribution.getPercentilesHistogram(), id, null)).percentiles((double[])this.lookupWithFallbackToAll(distribution.getPercentiles(), id, null)).sla(this.convertSla(id.getType(), this.lookup(distribution.getSla(), id, null))).minimumExpectedValue(this.convertMeterValue(id.getType(), this.lookup(distribution.getMinimumExpectedValue(), id, null))).maximumExpectedValue(this.convertMeterValue(id.getType(), this.lookup(distribution.getMaximumExpectedValue(), id, null))).build().merge(config);
    }

    private long[] convertSla(Meter.Type meterType, ServiceLevelAgreementBoundary[] sla) {
        if (sla == null) {
            return null;
        }
        long[] converted = Arrays.stream(sla).map((? super T candidate) -> candidate.getValue(meterType)).filter(Objects::nonNull).mapToLong(Long::longValue).toArray();
        return (long[])(converted.length != 0 ? converted : null);
    }

    private Long convertMeterValue(Meter.Type meterType, String value) {
        return value != null ? MeterValue.valueOf(value).getValue(meterType) : null;
    }

    private <T> T lookup(Map<String, T> values, Meter.Id id, T defaultValue) {
        if (values.isEmpty()) {
            return defaultValue;
        }
        return (T)this.doLookup(values, id, () -> defaultValue);
    }

    private <T> T lookupWithFallbackToAll(Map<String, T> values, Meter.Id id, T defaultValue) {
        if (values.isEmpty()) {
            return defaultValue;
        }
        return (T)this.doLookup(values, id, () -> values.getOrDefault("all", defaultValue));
    }

    private <T> T doLookup(Map<String, T> values, Meter.Id id, Supplier<T> defaultValue) {
        String name = id.getName();
        while (StringUtils.hasLength((String)name)) {
            T result = values.get(name);
            if (result != null) {
                return result;
            }
            int lastDot = name.lastIndexOf(46);
            name = lastDot != -1 ? name.substring(0, lastDot) : "";
        }
        return defaultValue.get();
    }
}

