/*
 * Decompiled with CFR 0.152.
 */
package ai.foremast.micrometer.autoconfigure;

import ai.foremast.micrometer.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import ai.foremast.micrometer.autoconfigure.MeterRegistryPostProcessor;
import ai.foremast.micrometer.autoconfigure.MetricsProperties;
import ai.foremast.micrometer.autoconfigure.PropertiesMeterFilter;
import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.Clock;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@ConditionalOnClass(value={Timed.class})
@EnableConfigurationProperties(value={MetricsProperties.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, RabbitAutoConfiguration.class, CacheAutoConfiguration.class})
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class})
public class MetricsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={Clock.class})
    public Clock micrometerClock() {
        return Clock.SYSTEM;
    }

    @Bean
    public static MeterRegistryPostProcessor meterRegistryPostProcessor() {
        return new MeterRegistryPostProcessor();
    }

    @Bean
    @Order(value=0)
    public PropertiesMeterFilter propertiesMeterFilter(MetricsProperties properties) {
        return new PropertiesMeterFilter(properties);
    }
}

