/*
 * Decompiled with CFR 0.152.
 */
package ai.foremast.micrometer.autoconfigure;

import ai.foremast.micrometer.autoconfigure.export.StringToDurationConverter;
import io.micrometer.core.instrument.Meter;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

final class MeterValue {
    private static final StringToDurationConverter durationConverter = new StringToDurationConverter();
    private final Object value;

    MeterValue(long value) {
        this.value = value;
    }

    MeterValue(Duration value) {
        this.value = value;
    }

    public Long getValue(Meter.Type meterType) {
        if (meterType == Meter.Type.DISTRIBUTION_SUMMARY) {
            return this.getDistributionSummaryValue();
        }
        if (meterType == Meter.Type.TIMER) {
            return this.getTimerValue();
        }
        return null;
    }

    private Long getDistributionSummaryValue() {
        if (this.value instanceof Long) {
            return (Long)this.value;
        }
        return null;
    }

    private Long getTimerValue() {
        if (this.value instanceof Long) {
            return TimeUnit.MILLISECONDS.toNanos((Long)this.value);
        }
        if (this.value instanceof Duration) {
            return ((Duration)this.value).toNanos();
        }
        return null;
    }

    public static MeterValue valueOf(String value) {
        if (MeterValue.isNumber(value)) {
            return new MeterValue(Long.parseLong(value));
        }
        return new MeterValue(durationConverter.convert(value));
    }

    public static MeterValue valueOf(long value) {
        return new MeterValue(value);
    }

    private static boolean isNumber(String value) {
        return value.chars().allMatch(Character::isDigit);
    }
}

