/*
 * Decompiled with CFR 0.152.
 */
package ai.foremast.micrometer.autoconfigure;

import ai.foremast.micrometer.autoconfigure.MeterRegistryConfigurer;
import ai.foremast.micrometer.autoconfigure.MeterRegistryCustomizer;
import ai.foremast.micrometer.autoconfigure.MetricsProperties;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.config.MeterFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;

class MeterRegistryPostProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    private BeanFactory beanFactory;
    private volatile MeterRegistryConfigurer configurer;

    MeterRegistryPostProcessor() {
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof MeterRegistry) {
            this.getConfigurer().configure((MeterRegistry)bean);
        }
        return bean;
    }

    private MeterRegistryConfigurer getConfigurer() {
        if (this.configurer == null) {
            Collection<Object> meterBinders = Collections.emptyList();
            Collection<Object> meterFilters = Collections.emptyList();
            List<MeterRegistryCustomizer<?>> meterRegistryCustomizers = Collections.emptyList();
            MetricsProperties properties = (MetricsProperties)this.beanFactory.getBean(MetricsProperties.class);
            if (this.beanFactory instanceof ListableBeanFactory) {
                ListableBeanFactory listableBeanFactory = (ListableBeanFactory)this.beanFactory;
                meterBinders = listableBeanFactory.getBeansOfType(MeterBinder.class).values();
                meterFilters = listableBeanFactory.getBeansOfType(MeterFilter.class).values();
                Map map = listableBeanFactory.getBeansOfType(MeterRegistryCustomizer.class);
                meterRegistryCustomizers = new ArrayList();
                for (MeterRegistryCustomizer c : map.values()) {
                    meterRegistryCustomizers.add(c);
                }
            }
            this.configurer = new MeterRegistryConfigurer(meterBinders, meterFilters, meterRegistryCustomizers, properties.isUseGlobalRegistry());
        }
        return this.configurer;
    }

    private <T> List<T> getOrEmpty(List<T> list) {
        return list != null ? list : Collections.emptyList();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

