/*
 * Decompiled with CFR 0.152.
 */
package ai.foremast.metrics.k8s.starter;

import ai.foremast.metrics.k8s.starter.K8sMetricsProperties;
import ai.foremast.micrometer.autoconfigure.MetricsProperties;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.MeterFilterReply;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.util.StringUtils;

public class CommonMetricsFilter
implements MeterFilter {
    private MetricsProperties properties;
    private String[] prefixes = new String[0];
    private Set<String> whitelist = new HashSet<String>();
    private Set<String> blacklist = new HashSet<String>();
    private K8sMetricsProperties k8sMetricsProperties;
    private boolean actionEnabled = false;

    public CommonMetricsFilter(K8sMetricsProperties k8sMetricsProperties, MetricsProperties properties) {
        String[] array;
        this.properties = properties;
        this.k8sMetricsProperties = k8sMetricsProperties;
        this.actionEnabled = k8sMetricsProperties.isEnableCommonMetricsFilterAction();
        String list = k8sMetricsProperties.getCommonMetricsBlacklist();
        if (list != null && !list.isEmpty()) {
            for (String str : array = StringUtils.tokenizeToStringArray((String)list, (String)",", (boolean)true, (boolean)true)) {
                str = this.filter(str.trim());
                this.blacklist.add(str);
            }
        }
        if ((list = k8sMetricsProperties.getCommonMetricsWhitelist()) != null && !list.isEmpty()) {
            for (String str : array = StringUtils.tokenizeToStringArray((String)list, (String)",", (boolean)true, (boolean)true)) {
                str = this.filter(str.trim());
                this.whitelist.add(str);
            }
        }
        if ((list = k8sMetricsProperties.getCommonMetricsPrefix()) != null && !list.isEmpty()) {
            this.prefixes = StringUtils.tokenizeToStringArray((String)list, (String)",", (boolean)true, (boolean)true);
        }
    }

    public MeterFilterReply accept(Meter.Id id) {
        if (!this.k8sMetricsProperties.isEnableCommonMetricsFilter()) {
            return super.accept(id);
        }
        String metricName = id.getName();
        Boolean enabled = this.lookupWithFallbackToAll(this.properties.getEnable(), id, null);
        if (enabled != null) {
            return enabled != false ? MeterFilterReply.NEUTRAL : MeterFilterReply.DENY;
        }
        if (this.whitelist.contains(metricName)) {
            return MeterFilterReply.NEUTRAL;
        }
        if (this.blacklist.contains(metricName)) {
            return MeterFilterReply.DENY;
        }
        for (String prefix : this.prefixes) {
            if (!metricName.startsWith(prefix)) continue;
            return MeterFilterReply.ACCEPT;
        }
        return MeterFilterReply.DENY;
    }

    protected String filter(String metricName) {
        return metricName.replace('_', '.');
    }

    public void enableMetric(String metricName) {
        if (this.blacklist.contains(metricName = this.filter(metricName))) {
            this.blacklist.remove(metricName);
        }
        if (!this.whitelist.contains(metricName)) {
            this.whitelist.add(metricName);
        }
    }

    public void disableMetric(String metricName) {
        if (this.whitelist.contains(metricName = this.filter(metricName))) {
            this.whitelist.remove(metricName);
        }
        if (!this.blacklist.contains(metricName)) {
            this.blacklist.add(metricName);
        }
    }

    private <T> T lookup(Map<String, T> values, Meter.Id id, T defaultValue) {
        if (values.isEmpty()) {
            return defaultValue;
        }
        return (T)this.doLookup(values, id, () -> defaultValue);
    }

    private <T> T lookupWithFallbackToAll(Map<String, T> values, Meter.Id id, T defaultValue) {
        if (values.isEmpty()) {
            return defaultValue;
        }
        return (T)this.doLookup(values, id, () -> values.getOrDefault("all", defaultValue));
    }

    private <T> T doLookup(Map<String, T> values, Meter.Id id, Supplier<T> defaultValue) {
        String name = id.getName();
        while (name != null && !name.isEmpty()) {
            T result = values.get(name);
            if (result != null) {
                return result;
            }
            int lastDot = name.lastIndexOf(46);
            name = lastDot != -1 ? name.substring(0, lastDot) : "";
        }
        return defaultValue.get();
    }

    public String[] getPrefixes() {
        return this.prefixes;
    }

    public void setPrefixes(String[] prefixes) {
        this.prefixes = prefixes;
    }

    public boolean isActionEnabled() {
        return this.actionEnabled;
    }
}

