/*
 * Decompiled with CFR 0.152.
 */
package ai.api.android;

import ai.api.AIConfiguration;
import android.content.res.AssetFileDescriptor;

public class AIConfiguration
extends ai.api.AIConfiguration {
    private final RecognitionEngine recognitionEngine;
    private AssetFileDescriptor recognizerStartSound;
    private AssetFileDescriptor recognizerStopSound;
    private AssetFileDescriptor recognizerCancelSound;
    private boolean voiceActivityDetectionEnabled = true;
    private boolean normalizeInputSound = false;

    public AIConfiguration(String clientAccessToken, AIConfiguration.SupportedLanguages language, RecognitionEngine recognitionEngine) {
        super(clientAccessToken);
        this.recognitionEngine = recognitionEngine;
        if (recognitionEngine == RecognitionEngine.Speaktoit && language == AIConfiguration.SupportedLanguages.Korean) {
            throw new UnsupportedOperationException("Only System recognition supported for Korean language");
        }
    }

    public RecognitionEngine getRecognitionEngine() {
        return this.recognitionEngine;
    }

    public boolean isVoiceActivityDetectionEnabled() {
        return this.voiceActivityDetectionEnabled;
    }

    public void setVoiceActivityDetectionEnabled(boolean voiceActivityDetectionEnabled) {
        this.voiceActivityDetectionEnabled = voiceActivityDetectionEnabled;
    }

    public void setNormalizeInputSound(boolean normalizeInputSound) {
        this.normalizeInputSound = normalizeInputSound;
    }

    public boolean isNormalizeInputSound() {
        return this.normalizeInputSound;
    }

    public AssetFileDescriptor getRecognizerStartSound() {
        return this.recognizerStartSound;
    }

    public void setRecognizerStartSound(AssetFileDescriptor recognizerStartSound) {
        this.recognizerStartSound = recognizerStartSound;
    }

    public AssetFileDescriptor getRecognizerStopSound() {
        return this.recognizerStopSound;
    }

    public void setRecognizerStopSound(AssetFileDescriptor recognizerStopSound) {
        this.recognizerStopSound = recognizerStopSound;
    }

    public AssetFileDescriptor getRecognizerCancelSound() {
        return this.recognizerCancelSound;
    }

    public void setRecognizerCancelSound(AssetFileDescriptor recognizerCancelSound) {
        this.recognizerCancelSound = recognizerCancelSound;
    }

    public static enum RecognitionEngine {
        Google,
        System,
        Speaktoit;

    }
}

