/*
 * Decompiled with CFR 0.152.
 */
package ai.api.util;

import ai.api.GsonFactory;
import ai.api.util.RecognizerChecker;
import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class VersionConfig {
    private static final String TAG = VersionConfig.class.getName();
    private static final Pattern DOT_PATTERN = Pattern.compile(".", 16);
    private static final Map<String, VersionConfig> configuration = new HashMap<String, VersionConfig>();
    private boolean destroyRecognizer = true;

    private VersionConfig() {
    }

    private VersionConfig(boolean destroyRecognizer) {
        this.destroyRecognizer = destroyRecognizer;
    }

    @Nullable
    public static VersionConfig init(Context context) {
        VersionConfig config = VersionConfig.getConfigByVersion(context);
        return config;
    }

    private static VersionConfig getConfigByVersion(Context context) {
        long number = VersionConfig.numberFromBuildVersion(RecognizerChecker.getGoogleRecognizerVersion(context));
        VersionConfig config = new VersionConfig();
        long prevVersionNumber = 0L;
        for (Map.Entry<String, VersionConfig> configEntry : configuration.entrySet()) {
            long versionNumber;
            String versionName = configEntry.getKey();
            if (TextUtils.isEmpty((CharSequence)versionName) || number < (versionNumber = VersionConfig.numberFromBuildVersion(versionName)) || prevVersionNumber >= versionNumber) continue;
            config.destroyRecognizer = configEntry.getValue().destroyRecognizer;
            prevVersionNumber = versionNumber;
        }
        return config;
    }

    public boolean isDestroyRecognizer() {
        return this.destroyRecognizer;
    }

    private static long numberFromBuildVersion(String buildVersion) {
        if (TextUtils.isEmpty((CharSequence)buildVersion)) {
            return 0L;
        }
        String[] parts = DOT_PATTERN.split(buildVersion);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < Math.min(3, parts.length); ++i) {
            builder.append(parts[i]);
        }
        try {
            return Long.parseLong(builder.toString());
        }
        catch (NumberFormatException ignored) {
            return 0L;
        }
    }

    public String toString() {
        return GsonFactory.getGson().toJson((Object)this);
    }

    static {
        configuration.put("5.9.26", new VersionConfig(true));
        configuration.put("4.7.13", new VersionConfig(false));
    }
}

