/*
 * Decompiled with CFR 0.152.
 */
package ai.api.util;

import android.util.Log;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public class VoiceActivityDetector {
    public static final String TAG = VoiceActivityDetector.class.getName();
    public static final int FRAME_SIZE_IN_BYTES = 320;
    private static final int SEQUENCE_LENGTH_MILLIS = 30;
    private static final int MIN_SPEECH_SEQUENCE_COUNT = 3;
    private static final long MIN_SILENCE_MILLIS = 800L;
    private static final long MAX_SILENCE_MILLIS = 3500L;
    private static final long SILENCE_DIFF_MILLIS = 2700L;
    private static final int NOISE_FRAMES = 15;
    public static final int NOISE_BYTES = 4800;
    private static final double ENERGY_FACTOR = 3.1;
    private static final int MIN_CZ = 5;
    private static final int MAX_CZ = 15;
    private final int sampleRate;
    private SpeechEventsListener eventsListener;
    private double noiseEnergy = 0.0;
    private long lastActiveTime = -1L;
    private long lastSequenceTime = 0L;
    private int sequenceCounter = 0;
    private long time = 0L;
    private int frameNumber;
    private long silenceMillis = 3500L;
    private boolean speechActive = false;
    private boolean enabled = true;
    private boolean process = true;
    private double sum = 0.0;
    private int size = 0;

    public VoiceActivityDetector(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public void processBuffer(byte[] buffer, int bytesRead) {
        if (!this.process) {
            return;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer, 0, bytesRead).order(ByteOrder.LITTLE_ENDIAN);
        ShortBuffer shorts = byteBuffer.asShortBuffer();
        boolean active = this.isFrameActive(shorts);
        int frameSize = bytesRead / 2;
        this.time = this.frameNumber * frameSize * 1000 / this.sampleRate;
        if (active) {
            if (this.lastActiveTime >= 0L && this.time - this.lastActiveTime < 30L) {
                if (++this.sequenceCounter >= 3) {
                    if (!this.speechActive) {
                        this.onSpeechBegin();
                    }
                    this.lastSequenceTime = this.time;
                    this.silenceMillis = Math.max(800L, this.silenceMillis - 675L);
                }
            } else {
                this.sequenceCounter = 1;
            }
            this.lastActiveTime = this.time;
        } else if (this.time - this.lastSequenceTime > this.silenceMillis) {
            if (this.speechActive) {
                this.onSpeechEnd();
            } else {
                this.onSpeechCancel();
            }
        }
    }

    private boolean isFrameActive(ShortBuffer frame) {
        int lastSign = 0;
        int czCount = 0;
        double energy = 0.0;
        int frameSize = frame.limit();
        this.size += frameSize;
        for (int i = 0; i < frameSize; ++i) {
            int sign;
            short raw = frame.get(i);
            double amplitude = (double)raw / 32767.0;
            energy += (double)((float)amplitude * (float)amplitude) / (double)frameSize;
            this.sum += (double)(raw * raw);
            int n = sign = (float)amplitude > 0.0f ? 1 : -1;
            if (lastSign != 0 && sign != lastSign) {
                ++czCount;
            }
            lastSign = sign;
        }
        boolean result = false;
        if (++this.frameNumber < 15) {
            this.noiseEnergy += energy / 15.0;
        } else if (czCount >= 5 && czCount <= 15 && energy > this.noiseEnergy * 3.1) {
            result = true;
        }
        return result;
    }

    public double calculateRms() {
        double rms = Math.sqrt(this.sum / (double)this.size) / 100.0;
        this.sum = 0.0;
        this.size = 0;
        return rms;
    }

    public void reset() {
        this.time = 0L;
        this.frameNumber = 0;
        this.noiseEnergy = 0.0;
        this.lastActiveTime = -1L;
        this.lastSequenceTime = 0L;
        this.sequenceCounter = 0;
        this.silenceMillis = 3500L;
        this.speechActive = false;
        this.process = true;
    }

    public void setSpeechListener(SpeechEventsListener eventsListener) {
        this.eventsListener = eventsListener;
    }

    private void onSpeechEnd() {
        Log.v((String)TAG, (String)"onSpeechEnd");
        this.speechActive = false;
        this.process = false;
        if (this.enabled && this.eventsListener != null) {
            this.eventsListener.onSpeechEnd();
        }
    }

    private void onSpeechCancel() {
        Log.v((String)TAG, (String)"onSpeechCancel");
        this.speechActive = false;
        this.process = false;
        if (this.eventsListener != null) {
            this.eventsListener.onSpeechCancel();
        }
    }

    private void onSpeechBegin() {
        Log.v((String)TAG, (String)"onSpeechBegin");
        this.speechActive = true;
        if (this.eventsListener != null) {
            this.eventsListener.onSpeechBegin();
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public static interface SpeechEventsListener {
        public void onSpeechBegin();

        public void onSpeechCancel();

        public void onSpeechEnd();
    }
}

