/*
 * Decompiled with CFR 0.152.
 */
package ai.api.services;

import ai.api.AIConfiguration;
import ai.api.AIService;
import ai.api.AIServiceException;
import ai.api.PartialResultsListener;
import ai.api.RequestExtras;
import ai.api.model.AIContext;
import ai.api.model.AIError;
import ai.api.model.AIRequest;
import ai.api.model.AIResponse;
import ai.api.util.RecognizerChecker;
import ai.api.util.VersionConfig;
import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.speech.RecognitionListener;
import android.speech.SpeechRecognizer;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GoogleRecognitionServiceImpl
extends AIService {
    private static final String TAG = GoogleRecognitionServiceImpl.class.getName();
    private SpeechRecognizer speechRecognizer;
    private final Object speechRecognizerLock = new Object();
    private RequestExtras requestExtras;
    private PartialResultsListener partialResultsListener;
    private final VersionConfig versionConfig;
    private volatile boolean recognitionActive = false;
    private volatile boolean wasReadyForSpeech;
    private final Map<Integer, String> errorMessages = new HashMap<Integer, String>();

    public GoogleRecognitionServiceImpl(Context context, AIConfiguration config) {
        super(config, context);
        this.errorMessages.put(1, "Network operation timed out.");
        this.errorMessages.put(2, "Other network related errors.");
        this.errorMessages.put(3, "Audio recording error.");
        this.errorMessages.put(4, "Server sends error status.");
        this.errorMessages.put(5, "Other client side errors.");
        this.errorMessages.put(6, "No speech input.");
        this.errorMessages.put(7, "No recognition result matched.");
        this.errorMessages.put(8, "RecognitionService busy.");
        this.errorMessages.put(9, "Insufficient permissions.");
        ComponentName component = RecognizerChecker.findGoogleRecognizer(context);
        if (component == null) {
            Log.w((String)TAG, (String)"Google Recognizer application not found on device. Quality of the recognition may be low. Please check if Google Search application installed and enabled.");
        }
        this.versionConfig = VersionConfig.init(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeRecognizer() {
        if (this.speechRecognizer != null) {
            return;
        }
        Object object = this.speechRecognizerLock;
        synchronized (object) {
            if (this.speechRecognizer != null) {
                this.speechRecognizer.destroy();
                this.speechRecognizer = null;
            }
            ComponentName component = RecognizerChecker.findGoogleRecognizer(this.context);
            this.speechRecognizer = SpeechRecognizer.createSpeechRecognizer((Context)this.context, (ComponentName)component);
            this.speechRecognizer.setRecognitionListener((RecognitionListener)new InternalRecognitionListener());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearRecognizer() {
        Log.d((String)TAG, (String)"clearRecognizer");
        if (this.speechRecognizer != null) {
            Object object = this.speechRecognizerLock;
            synchronized (object) {
                if (this.speechRecognizer != null) {
                    this.speechRecognizer.destroy();
                    this.speechRecognizer = null;
                }
            }
        }
    }

    private void sendRequest(@NonNull AIRequest aiRequest, final @Nullable RequestExtras requestExtras) {
        if (aiRequest == null) {
            throw new IllegalArgumentException("aiRequest must be not null");
        }
        AsyncTask<AIRequest, Integer, AIResponse> task = new AsyncTask<AIRequest, Integer, AIResponse>(){
            private AIError aiError;

            protected AIResponse doInBackground(AIRequest ... params) {
                AIRequest request = params[0];
                try {
                    return GoogleRecognitionServiceImpl.this.aiDataService.request(request, requestExtras);
                }
                catch (AIServiceException e) {
                    this.aiError = new AIError(e);
                    return null;
                }
            }

            protected void onPostExecute(AIResponse response) {
                if (response != null) {
                    GoogleRecognitionServiceImpl.this.onResult(response);
                } else {
                    GoogleRecognitionServiceImpl.this.onError(this.aiError);
                }
            }
        };
        task.execute((Object[])new AIRequest[]{aiRequest});
    }

    @Override
    public void startListening() {
        this.startListening(new RequestExtras());
    }

    @Override
    public void startListening(List<AIContext> contexts) {
        this.startListening(new RequestExtras(contexts, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startListening(RequestExtras requestExtras) {
        if (!this.recognitionActive) {
            Object object = this.speechRecognizerLock;
            synchronized (object) {
                this.requestExtras = requestExtras;
                if (!this.checkPermissions()) {
                    AIError aiError = new AIError("RECORD_AUDIO permission is denied. Please request permission from user.");
                    this.onError(aiError);
                    return;
                }
                this.initializeRecognizer();
                this.recognitionActive = true;
                Intent sttIntent = this.createRecognitionIntent();
                try {
                    this.wasReadyForSpeech = false;
                    this.speechRecognizer.startListening(sttIntent);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        Log.w((String)TAG, (String)"Trying to start recognition while another recognition active");
        if (!this.wasReadyForSpeech) {
            this.cancel();
        }
    }

    private Intent createRecognitionIntent() {
        Intent sttIntent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        sttIntent.putExtra("android.speech.extra.LANGUAGE_MODEL", "free_form");
        String language = this.config.getLanguage().replace('-', '_');
        sttIntent.putExtra("android.speech.extra.LANGUAGE", language);
        sttIntent.putExtra("android.speech.extra.LANGUAGE_PREFERENCE", language);
        sttIntent.putExtra("android.speech.extra.PARTIAL_RESULTS", true);
        sttIntent.putExtra("calling_package", this.context.getPackageName());
        sttIntent.putExtra("android.speech.extra.EXTRA_ADDITIONAL_LANGUAGES", new String[]{language});
        return sttIntent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopListening() {
        Object object = this.speechRecognizerLock;
        synchronized (object) {
            if (this.speechRecognizer != null) {
                this.speechRecognizer.stopListening();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.speechRecognizerLock;
        synchronized (object) {
            if (this.recognitionActive) {
                this.recognitionActive = false;
                if (this.speechRecognizer != null) {
                    this.speechRecognizer.cancel();
                }
                this.onListeningCancelled();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartRecognition() {
        this.recognitionActive = false;
        Object object = this.speechRecognizerLock;
        synchronized (object) {
            try {
                if (this.speechRecognizer != null) {
                    this.speechRecognizer.cancel();
                    Intent intent = this.createRecognitionIntent();
                    this.wasReadyForSpeech = false;
                    this.speechRecognizer.startListening(intent);
                    this.recognitionActive = true;
                }
            }
            catch (Exception e) {
                this.stopListening();
            }
        }
    }

    @Override
    public void pause() {
        this.clearRecognizer();
    }

    @Override
    public void resume() {
    }

    public void setPartialResultsListener(PartialResultsListener partialResultsListener) {
        this.partialResultsListener = partialResultsListener;
    }

    protected void onPartialResults(List<String> partialResults) {
        if (this.partialResultsListener != null) {
            this.partialResultsListener.onPartialResults(partialResults);
        }
    }

    private boolean isDestroyRecognizer() {
        return this.versionConfig == null || this.versionConfig.isDestroyRecognizer();
    }

    private class InternalRecognitionListener
    implements RecognitionListener {
        private InternalRecognitionListener() {
        }

        public void onReadyForSpeech(Bundle params) {
            if (GoogleRecognitionServiceImpl.this.recognitionActive) {
                GoogleRecognitionServiceImpl.this.onListeningStarted();
            }
            GoogleRecognitionServiceImpl.this.wasReadyForSpeech = true;
        }

        public void onBeginningOfSpeech() {
        }

        public void onRmsChanged(float rmsdB) {
            if (GoogleRecognitionServiceImpl.this.recognitionActive) {
                GoogleRecognitionServiceImpl.this.onAudioLevelChanged(rmsdB);
            }
        }

        public void onBufferReceived(byte[] buffer) {
        }

        public void onEndOfSpeech() {
            if (GoogleRecognitionServiceImpl.this.recognitionActive) {
                GoogleRecognitionServiceImpl.this.onListeningFinished();
            }
        }

        public void onError(int error) {
            if (error == 7 && !GoogleRecognitionServiceImpl.this.wasReadyForSpeech) {
                Log.d((String)TAG, (String)"SpeechRecognizer.ERROR_NO_MATCH, restartRecognition()");
                GoogleRecognitionServiceImpl.this.restartRecognition();
                return;
            }
            if (GoogleRecognitionServiceImpl.this.recognitionActive) {
                AIError aiError;
                if (GoogleRecognitionServiceImpl.this.errorMessages.containsKey(error)) {
                    String description = (String)GoogleRecognitionServiceImpl.this.errorMessages.get(error);
                    aiError = new AIError("Speech recognition engine error: " + description);
                } else {
                    aiError = new AIError("Speech recognition engine error: " + error);
                }
                GoogleRecognitionServiceImpl.this.onError(aiError);
            }
            if (GoogleRecognitionServiceImpl.this.isDestroyRecognizer()) {
                GoogleRecognitionServiceImpl.this.clearRecognizer();
            }
            GoogleRecognitionServiceImpl.this.recognitionActive = false;
        }

        @TargetApi(value=14)
        public void onResults(Bundle results) {
            if (GoogleRecognitionServiceImpl.this.recognitionActive) {
                ArrayList recognitionResults = results.getStringArrayList("results_recognition");
                float[] rates = null;
                if (Build.VERSION.SDK_INT >= 14) {
                    rates = results.getFloatArray("confidence_scores");
                }
                if (recognitionResults == null || recognitionResults.isEmpty()) {
                    GoogleRecognitionServiceImpl.this.onResult(new AIResponse());
                } else {
                    AIRequest aiRequest = new AIRequest();
                    if (rates != null) {
                        aiRequest.setQuery(recognitionResults.toArray(new String[recognitionResults.size()]), rates);
                    } else {
                        aiRequest.setQuery((String)recognitionResults.get(0));
                    }
                    GoogleRecognitionServiceImpl.this.onPartialResults(recognitionResults);
                    GoogleRecognitionServiceImpl.this.sendRequest(aiRequest, GoogleRecognitionServiceImpl.this.requestExtras);
                }
            }
            if (GoogleRecognitionServiceImpl.this.isDestroyRecognizer()) {
                GoogleRecognitionServiceImpl.this.clearRecognizer();
            }
            GoogleRecognitionServiceImpl.this.recognitionActive = false;
        }

        public void onPartialResults(Bundle partialResults) {
            ArrayList partialRecognitionResults;
            if (GoogleRecognitionServiceImpl.this.recognitionActive && (partialRecognitionResults = partialResults.getStringArrayList("results_recognition")) != null && !partialRecognitionResults.isEmpty()) {
                GoogleRecognitionServiceImpl.this.onPartialResults(partialRecognitionResults);
            }
        }

        public void onEvent(int eventType, Bundle params) {
        }
    }
}

