/*
 * Decompiled with CFR 0.152.
 */
package ai.api.model;

import ai.api.model.AIOutputContext;
import ai.api.model.Fulfillment;
import ai.api.model.Metadata;
import ai.api.util.ParametersConverter;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class Result
implements Serializable {
    private static final String DATE_FORMAT_ERROR_MESSAGE = "'%s' parameter has value '%s' and can't be parsed as a Date or Time";
    @SerializedName(value="action")
    private String action;
    @SerializedName(value="parameters")
    private HashMap<String, JsonElement> parameters;
    @SerializedName(value="contexts")
    private List<AIOutputContext> contexts;
    @SerializedName(value="metadata")
    private Metadata metadata;
    @SerializedName(value="resolvedQuery")
    private String resolvedQuery;
    @SerializedName(value="fulfillment")
    private Fulfillment fulfillment;
    @SerializedName(value="actionIncomplete")
    private boolean actionIncomplete;

    @NonNull
    public String getAction() {
        if (this.action == null) {
            return "";
        }
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public HashMap<String, JsonElement> getParameters() {
        return this.parameters;
    }

    public String getStringParameter(String name) {
        return this.getStringParameter(name, "");
    }

    public String getStringParameter(String name, String defaultValue) {
        if (this.parameters.containsKey(name)) {
            String parameterValue = this.parameters.get(name).getAsString();
            return parameterValue;
        }
        return defaultValue;
    }

    public Date getDateParameter(String name) throws IllegalArgumentException {
        return this.getDateParameter(name, null);
    }

    public Date getDateParameter(String name, Date defaultValue) throws IllegalArgumentException {
        if (this.parameters.containsKey(name)) {
            String parameterStringValue = this.parameters.get(name).getAsString();
            if (TextUtils.isEmpty((CharSequence)parameterStringValue)) {
                return defaultValue;
            }
            try {
                return ParametersConverter.parseDate(parameterStringValue);
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException(String.format(DATE_FORMAT_ERROR_MESSAGE, name, parameterStringValue), pe);
            }
        }
        return defaultValue;
    }

    public Date getDateTimeParameter(String name) throws IllegalArgumentException {
        return this.getDateTimeParameter(name, null);
    }

    public Date getDateTimeParameter(String name, Date defaultValue) throws IllegalArgumentException {
        if (this.parameters.containsKey(name)) {
            String parameterStringValue = this.parameters.get(name).getAsString();
            if (TextUtils.isEmpty((CharSequence)parameterStringValue)) {
                return defaultValue;
            }
            try {
                return ParametersConverter.parseDateTime(parameterStringValue);
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException(String.format(DATE_FORMAT_ERROR_MESSAGE, name, parameterStringValue), pe);
            }
        }
        return defaultValue;
    }

    public Date getTimeParameter(String name) throws IllegalArgumentException {
        return this.getTimeParameter(name, null);
    }

    public Date getTimeParameter(String name, Date defaultValue) throws IllegalArgumentException {
        if (this.parameters.containsKey(name)) {
            String parameterStringValue = this.parameters.get(name).getAsString();
            if (TextUtils.isEmpty((CharSequence)parameterStringValue)) {
                return defaultValue;
            }
            try {
                return ParametersConverter.parseTime(parameterStringValue);
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException(String.format(DATE_FORMAT_ERROR_MESSAGE, name, parameterStringValue), pe);
            }
        }
        return defaultValue;
    }

    public int getIntParameter(String name) {
        return this.getIntParameter(name, 0);
    }

    public int getIntParameter(String name, int defaultValue) {
        if (this.parameters.containsKey(name)) {
            String parameterStringValue = this.parameters.get(name).getAsString();
            if (TextUtils.isEmpty((CharSequence)parameterStringValue)) {
                return defaultValue;
            }
            return ParametersConverter.parseInteger(parameterStringValue);
        }
        return defaultValue;
    }

    public float getFloatParameter(String name) {
        return this.getFloatParameter(name, 0.0f);
    }

    public float getFloatParameter(String name, float defaultValue) {
        if (this.parameters.containsKey(name)) {
            String parameterStringValue = this.parameters.get(name).getAsString();
            if (TextUtils.isEmpty((CharSequence)parameterStringValue)) {
                return defaultValue;
            }
            return ParametersConverter.parseFloat(parameterStringValue);
        }
        return defaultValue;
    }

    public JsonObject getComplexParameter(String name, JsonObject defaultValue) {
        if (this.parameters.containsKey(name)) {
            JsonObject jsonObject = this.parameters.get(name).getAsJsonObject();
            if (jsonObject == null) {
                return defaultValue;
            }
            return jsonObject;
        }
        return defaultValue;
    }

    public JsonObject getComplexParameter(String name) {
        return this.getComplexParameter(name, null);
    }

    public List<AIOutputContext> getContexts() {
        return this.contexts;
    }

    public AIOutputContext getContext(String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("name argument must be not empty");
        }
        if (this.contexts == null) {
            return null;
        }
        for (AIOutputContext c : this.contexts) {
            if (!name.equalsIgnoreCase(c.getName())) continue;
            return c;
        }
        return null;
    }

    public String getResolvedQuery() {
        return this.resolvedQuery;
    }

    public void setResolvedQuery(String resolvedQuery) {
        this.resolvedQuery = resolvedQuery;
    }

    public Fulfillment getFulfillment() {
        return this.fulfillment;
    }

    public void setFulfillment(Fulfillment fulfillment) {
        this.fulfillment = fulfillment;
    }

    public boolean isActionIncomplete() {
        return this.actionIncomplete;
    }

    public void setActionIncomplete(boolean actionIncomplete) {
        this.actionIncomplete = actionIncomplete;
    }

    void trimParameters() {
        if (this.parameters != null) {
            LinkedList<String> parametersToTrim = new LinkedList<String>();
            for (String key : this.parameters.keySet()) {
                JsonElement jsonElement = this.parameters.get(key);
                if (jsonElement == null || !jsonElement.isJsonPrimitive() || !((JsonPrimitive)jsonElement).isString() || !TextUtils.isEmpty((CharSequence)jsonElement.getAsString())) continue;
                parametersToTrim.add(key);
            }
            for (String key : parametersToTrim) {
                this.parameters.remove(key);
            }
        }
    }

    public String toString() {
        return String.format("Result {action='%s', resolvedQuery='%s'}", this.action, this.resolvedQuery);
    }
}

