/*
 * Decompiled with CFR 0.152.
 */
package ai.api.model;

import ai.api.model.AIOutputContext;
import ai.api.model.Metadata;
import android.text.TextUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;

public class Result
implements Serializable {
    @SerializedName(value="speech")
    private String speech;
    @SerializedName(value="action")
    private String action;
    @SerializedName(value="parameters")
    private HashMap<String, JsonElement> parameters;
    @SerializedName(value="contexts")
    private AIOutputContext[] contexts;
    @SerializedName(value="metadata")
    private Metadata metadata;
    @SerializedName(value="resolvedQuery")
    private String resolvedQuery;

    public String getSpeech() {
        return this.speech;
    }

    public void setSpeech(String speech) {
        this.speech = speech;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public HashMap<String, JsonElement> getParameters() {
        return this.parameters;
    }

    public AIOutputContext[] getContexts() {
        return this.contexts;
    }

    public String getResolvedQuery() {
        return this.resolvedQuery;
    }

    public void setResolvedQuery(String resolvedQuery) {
        this.resolvedQuery = resolvedQuery;
    }

    void trimParameters() {
        if (this.parameters != null) {
            LinkedList<String> parametersToTrim = new LinkedList<String>();
            for (String key : this.parameters.keySet()) {
                JsonElement jsonElement = this.parameters.get(key);
                if (jsonElement == null || !jsonElement.isJsonPrimitive() || !((JsonPrimitive)jsonElement).isString() || !TextUtils.isEmpty((CharSequence)jsonElement.getAsString())) continue;
                parametersToTrim.add(key);
            }
            for (String key : parametersToTrim) {
                this.parameters.remove(key);
            }
        }
    }

    public String toString() {
        return String.format("Result {speech='%s', action='%s', resolvedQuery='%s'}", this.speech, this.action, this.resolvedQuery);
    }
}

