/*
 * Decompiled with CFR 0.152.
 */
package ai.api.http;

import android.os.Environment;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

public class HttpClient {
    public static final String TAG = HttpClient.class.getName();
    private static final int CHUNK_LENGTH = 2048;
    private final HttpURLConnection connection;
    private OutputStream os;
    private final String delimiter = "--";
    private final String boundary = "SwA" + Long.toString(System.currentTimeMillis()) + "SwA";
    private boolean writeSoundLog;

    public HttpClient(HttpURLConnection connection) {
        this.connection = connection;
    }

    public void connectForMultipart() throws IOException {
        this.connection.setRequestProperty("Connection", "Keep-Alive");
        this.connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
        this.connection.setChunkedStreamingMode(2048);
        this.connection.connect();
        this.os = this.connection.getOutputStream();
    }

    public void addFormPart(String paramName, String value) throws IOException {
        this.os.write(("--" + this.boundary + "\r\n").getBytes());
        this.os.write("Content-Type: application/json\r\n".getBytes());
        this.os.write(("Content-Disposition: form-data; name=\"" + paramName + "\"\r\n").getBytes());
        this.os.write(("\r\n" + value + "\r\n").getBytes());
    }

    public void addFilePart(String paramName, String fileName, InputStream data) throws IOException {
        this.os.write(("--" + this.boundary + "\r\n").getBytes());
        this.os.write(("Content-Disposition: form-data; name=\"" + paramName + "\"; filename=\"" + fileName + "\"\r\n").getBytes());
        this.os.write("Content-Type: audio/wav\r\n".getBytes());
        this.os.write("\r\n".getBytes());
        Log.v((String)TAG, (String)"Sound write start");
        FileOutputStream outputStream = null;
        if (this.writeSoundLog) {
            File cacheDir = new File(Environment.getExternalStorageDirectory(), "sound_log");
            if (!cacheDir.exists()) {
                cacheDir.mkdirs();
            }
            Log.d((String)TAG, (String)cacheDir.getAbsolutePath());
            File soundFile = new File(cacheDir, "log.wav");
            outputStream = new FileOutputStream(soundFile, false);
        }
        int bufferSize = 4096;
        byte[] buffer = new byte[4096];
        int bytesActuallyRead = data.read(buffer, 0, 4096);
        Log.v((String)TAG, (String)("Bytes read: " + bytesActuallyRead));
        while (bytesActuallyRead >= 0) {
            if (bytesActuallyRead > 0) {
                this.os.write(buffer, 0, bytesActuallyRead);
                if (this.writeSoundLog) {
                    outputStream.write(buffer, 0, bytesActuallyRead);
                }
            }
            bytesActuallyRead = data.read(buffer, 0, 4096);
            Log.v((String)TAG, (String)("Bytes read: " + bytesActuallyRead));
        }
        if (this.writeSoundLog) {
            outputStream.close();
        }
        Log.v((String)TAG, (String)"Sound write finished");
        this.os.write("\r\n".getBytes());
    }

    public void finishMultipart() throws IOException {
        this.os.write(("--" + this.boundary + "--" + "\r\n").getBytes());
        this.os.close();
    }

    public String getResponse() throws IOException {
        BufferedInputStream inputStream = new BufferedInputStream(this.connection.getInputStream());
        String response = IOUtils.toString((InputStream)inputStream, (Charset)Charsets.UTF_8);
        ((InputStream)inputStream).close();
        return response;
    }

    public String getErrorString() {
        try {
            BufferedInputStream inputStream = new BufferedInputStream(this.connection.getErrorStream());
            String response = IOUtils.toString((InputStream)inputStream, (Charset)Charsets.UTF_8);
            ((InputStream)inputStream).close();
            return response;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setWriteSoundLog(boolean writeSoundLog) {
        this.writeSoundLog = writeSoundLog;
    }
}

