/*
 * Decompiled with CFR 0.152.
 */
package ai.api.util;

import android.util.Log;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

public class VoiceActivityDetector {
    public static final String TAG = VoiceActivityDetector.class.getName();
    private final int sampleRate;
    private SpeechEventsListener eventsListener;
    private double averageNoiseEnergy = 0.0;
    private double lastActiveTime = -1.0;
    private double lastSequenceTime = 0.0;
    private int sequenceCounter = 0;
    private double time = 0.0;
    private final double sequenceLengthMilis = 100.0;
    private final int minSpeechSequenceCount = 3;
    private final double energyFactor = 1.1;
    private final double maxSilenceLengthMilis = 350.0;
    private final double minSilenceLengthMilis = 80.0;
    private double silenceLengthMilis = 350.0;
    private boolean speechActive = false;
    private final int startNoiseInterval = 150;
    private int minAudioBufferSize = 1920;

    public VoiceActivityDetector(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public void processBuffer(byte[] buffer, int bytesRead) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer, 0, bytesRead);
        ShortBuffer shorts = byteBuffer.asShortBuffer();
        boolean active = this.isFrameActive(shorts);
        int frameSize = bytesRead / 2;
        this.time += (double)(frameSize * 1000 / this.sampleRate);
        if (active) {
            if (this.lastActiveTime >= 0.0 && this.time - this.lastActiveTime < 100.0) {
                ++this.sequenceCounter;
                if (this.sequenceCounter >= 3) {
                    if (!this.speechActive) {
                        this.onSpeechBegin();
                    }
                    this.speechActive = true;
                    this.lastSequenceTime = this.time;
                    this.silenceLengthMilis = Math.max(80.0, this.silenceLengthMilis - 67.5);
                }
            } else {
                this.sequenceCounter = 1;
            }
            this.lastActiveTime = this.time;
        } else if (this.time - this.lastSequenceTime > this.silenceLengthMilis && this.lastSequenceTime > 0.0 && this.speechActive) {
            this.speechActive = false;
            this.onSpeechEnd();
        }
    }

    private boolean isFrameActive(ShortBuffer frame) {
        int lastSign = 0;
        int czCount = 0;
        double energy = 0.0;
        int frameSize = frame.limit();
        for (int i = 0; i < frameSize; ++i) {
            short amplitudeValue = frame.get(i);
            energy += (double)(amplitudeValue * amplitudeValue / frameSize);
            int sign = amplitudeValue > 0 ? 1 : -1;
            if (lastSign != 0 && sign != lastSign) {
                ++czCount;
            }
            lastSign = sign;
        }
        this.onChangeLevel(Math.sqrt(energy / (double)frameSize) / 10.0);
        boolean result = false;
        if (this.time < 150.0) {
            this.averageNoiseEnergy = (this.averageNoiseEnergy + energy) / 2.0;
        } else {
            int minCZ = (int)((double)frameSize * 0.3333333333333333);
            int maxCZ = (int)((double)frameSize * 0.75);
            if (czCount >= minCZ && czCount <= maxCZ && energy > this.averageNoiseEnergy * 1.1) {
                result = true;
            }
        }
        return result;
    }

    private void onChangeLevel(double energy) {
        if (this.eventsListener != null) {
            this.eventsListener.onAudioLevelChanged(energy);
        }
    }

    public void reset() {
        this.time = 0.0;
        this.averageNoiseEnergy = 0.0;
        this.lastActiveTime = -1.0;
        this.lastSequenceTime = 0.0;
        this.sequenceCounter = 0;
        this.silenceLengthMilis = 350.0;
        this.speechActive = false;
    }

    public void setSpeechListener(SpeechEventsListener eventsListener) {
        this.eventsListener = eventsListener;
    }

    private void onSpeechEnd() {
        Log.v((String)TAG, (String)"onSpeechEnd");
        if (this.eventsListener != null) {
            this.eventsListener.onSpeechEnd();
        }
    }

    private void onSpeechBegin() {
        Log.v((String)TAG, (String)"onSpeechBegin");
        if (this.eventsListener != null) {
            this.eventsListener.onSpeechBegin();
        }
    }

    public void setMinAudioBufferSize(int minAudioBufferSize) {
        this.minAudioBufferSize = minAudioBufferSize;
    }

    public static interface SpeechEventsListener {
        public void onSpeechBegin();

        public void onSpeechEnd();

        public void onAudioLevelChanged(double var1);
    }
}

