/*
 * Decompiled with CFR 0.152.
 */
package ai.api;

import ai.api.AIConfiguration;
import ai.api.AIService;
import ai.api.AIServiceException;
import ai.api.model.AIContext;
import ai.api.model.AIError;
import ai.api.model.AIRequest;
import ai.api.model.AIResponse;
import ai.api.util.RecognizerChecker;
import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.speech.RecognitionListener;
import android.speech.SpeechRecognizer;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GoogleRecognitionServiceImpl
extends AIService {
    private static final String TAG = GoogleRecognitionServiceImpl.class.getName();
    private SpeechRecognizer speechRecognizer;
    private final Object speechRecognizerLock = new Object();
    private volatile boolean recognitionActive = false;
    private final Handler handler;
    private final Map<Integer, String> errorMessages = new HashMap<Integer, String>();
    private List<AIContext> contexts;

    protected GoogleRecognitionServiceImpl(Context context, AIConfiguration config) {
        super(config, context);
        this.errorMessages.put(1, "Network operation timed out.");
        this.errorMessages.put(2, "Other network related errors.");
        this.errorMessages.put(3, "Audio recording error.");
        this.errorMessages.put(4, "Server sends error status.");
        this.errorMessages.put(5, "Other client side errors.");
        this.errorMessages.put(6, "No speech input.");
        this.errorMessages.put(7, "No recognition result matched.");
        this.errorMessages.put(8, "RecognitionService busy.");
        this.errorMessages.put(9, "Insufficient permissions.");
        ComponentName googleRecognizerComponent = RecognizerChecker.findGoogleRecognizer(context);
        if (googleRecognizerComponent == null) {
            Log.w((String)TAG, (String)"Google Recognizer application not found on device. Quality of the recognition may be low. Please check if Google Search application installed and enabled.");
        }
        this.handler = new Handler(context.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeRecognizer() {
        Object object = this.speechRecognizerLock;
        synchronized (object) {
            ComponentName googleRecognizerComponent;
            if (this.speechRecognizer != null) {
                this.speechRecognizer.destroy();
                this.speechRecognizer = null;
            }
            this.speechRecognizer = (googleRecognizerComponent = RecognizerChecker.findGoogleRecognizer(this.context)) == null ? SpeechRecognizer.createSpeechRecognizer((Context)this.context) : SpeechRecognizer.createSpeechRecognizer((Context)this.context, (ComponentName)googleRecognizerComponent);
            this.speechRecognizer.setRecognitionListener((RecognitionListener)new InternalRecognitionListener());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearRecognizer() {
        if (this.speechRecognizer != null) {
            Object object = this.speechRecognizerLock;
            synchronized (object) {
                if (this.speechRecognizer != null) {
                    this.speechRecognizer.destroy();
                    this.speechRecognizer = null;
                }
            }
        }
    }

    private void sendRequest(AIRequest aiRequest) {
        if (aiRequest == null) {
            throw new IllegalArgumentException("aiRequest must be not null");
        }
        AsyncTask<AIRequest, Integer, AIResponse> task = new AsyncTask<AIRequest, Integer, AIResponse>(){
            private AIError aiError;

            protected AIResponse doInBackground(AIRequest ... params) {
                AIRequest request = params[0];
                try {
                    AIResponse response = GoogleRecognitionServiceImpl.this.aiDataService.request(request);
                    return response;
                }
                catch (AIServiceException e) {
                    this.aiError = new AIError(e);
                    return null;
                }
            }

            protected void onPostExecute(AIResponse response) {
                if (response != null) {
                    GoogleRecognitionServiceImpl.this.onResult(response);
                } else {
                    GoogleRecognitionServiceImpl.this.onError(this.aiError);
                }
            }
        };
        task.execute((Object[])new AIRequest[]{aiRequest});
    }

    @Override
    public void startListening() {
        this.startListening(null);
    }

    @Override
    public void startListening(List<AIContext> contexts) {
        if (!this.recognitionActive) {
            this.contexts = contexts;
            final Intent sttIntent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
            sttIntent.putExtra("android.speech.extra.LANGUAGE_MODEL", "free_form");
            sttIntent.putExtra("android.speech.extra.LANGUAGE", this.config.getLanguage());
            sttIntent.putExtra("android.speech.extra.LANGUAGE_PREFERENCE", this.config.getLanguage());
            sttIntent.putExtra("android.speech.extra.EXTRA_ADDITIONAL_LANGUAGES", new String[0]);
            this.runInUiThread(new Runnable(){

                @Override
                public void run() {
                    GoogleRecognitionServiceImpl.this.initializeRecognizer();
                    GoogleRecognitionServiceImpl.this.speechRecognizer.startListening(sttIntent);
                    GoogleRecognitionServiceImpl.this.recognitionActive = true;
                }
            });
        } else {
            Log.w((String)TAG, (String)"Trying to start recognition while another recognition active");
        }
    }

    @Override
    public void stopListening() {
        if (this.recognitionActive) {
            this.runInUiThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = GoogleRecognitionServiceImpl.this.speechRecognizerLock;
                    synchronized (object) {
                        if (GoogleRecognitionServiceImpl.this.recognitionActive) {
                            GoogleRecognitionServiceImpl.this.speechRecognizer.stopListening();
                            GoogleRecognitionServiceImpl.this.recognitionActive = false;
                        }
                    }
                }
            });
        } else {
            Log.w((String)TAG, (String)"Trying to stop listening while not active recognition");
        }
    }

    @Override
    public void cancel() {
        if (this.recognitionActive) {
            this.runInUiThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = GoogleRecognitionServiceImpl.this.speechRecognizerLock;
                    synchronized (object) {
                        if (GoogleRecognitionServiceImpl.this.recognitionActive) {
                            GoogleRecognitionServiceImpl.this.speechRecognizer.cancel();
                            GoogleRecognitionServiceImpl.this.recognitionActive = false;
                        }
                    }
                }
            });
        }
    }

    @Override
    public void pause() {
        super.pause();
        this.clearRecognizer();
    }

    @Override
    public void resume() {
        super.resume();
    }

    private void runInUiThread(Runnable runnable) {
        this.handler.post(runnable);
    }

    private class InternalRecognitionListener
    implements RecognitionListener {
        private InternalRecognitionListener() {
        }

        public void onReadyForSpeech(Bundle params) {
            GoogleRecognitionServiceImpl.this.onListeningStarted();
        }

        public void onBeginningOfSpeech() {
        }

        public void onRmsChanged(float rmsdB) {
            GoogleRecognitionServiceImpl.this.onAudioLevelChanged(rmsdB);
        }

        public void onBufferReceived(byte[] buffer) {
        }

        public void onEndOfSpeech() {
            GoogleRecognitionServiceImpl.this.onListeningFinished();
        }

        public void onError(int error) {
            AIError aiError;
            GoogleRecognitionServiceImpl.this.recognitionActive = false;
            if (GoogleRecognitionServiceImpl.this.errorMessages.containsKey(error)) {
                String description = (String)GoogleRecognitionServiceImpl.this.errorMessages.get(error);
                aiError = new AIError("Speech recognition engine error: " + description);
            } else {
                aiError = new AIError("Speech recognition engine error: " + error);
            }
            GoogleRecognitionServiceImpl.this.onError(aiError);
        }

        @TargetApi(value=14)
        public void onResults(Bundle results) {
            if (GoogleRecognitionServiceImpl.this.recognitionActive) {
                GoogleRecognitionServiceImpl.this.recognitionActive = false;
                ArrayList recognitionResults = results.getStringArrayList("results_recognition");
                float[] rates = null;
                if (Build.VERSION.SDK_INT >= 14) {
                    rates = results.getFloatArray("confidence_scores");
                }
                if (recognitionResults == null || recognitionResults.size() == 0) {
                    GoogleRecognitionServiceImpl.this.onResult(new AIResponse());
                } else {
                    AIRequest aiRequest = new AIRequest();
                    if (rates != null) {
                        aiRequest.setQuery(recognitionResults.toArray(new String[recognitionResults.size()]), rates);
                    } else {
                        aiRequest.setQuery((String)recognitionResults.get(0));
                    }
                    if (GoogleRecognitionServiceImpl.this.contexts != null) {
                        aiRequest.setContexts(GoogleRecognitionServiceImpl.this.contexts);
                    }
                    GoogleRecognitionServiceImpl.this.sendRequest(aiRequest);
                    GoogleRecognitionServiceImpl.this.clearRecognizer();
                }
            }
        }

        public void onPartialResults(Bundle partialResults) {
        }

        public void onEvent(int eventType, Bundle params) {
        }
    }
}

