/*
 * Decompiled with CFR 0.152.
 */
package ai.api;

import android.content.res.AssetFileDescriptor;
import android.text.TextUtils;
import java.net.Proxy;

public class AIConfiguration {
    private static final String SERVICE_PROD_URL = "https://api.api.ai/v1/";
    protected static final String CURRENT_PROTOCOL_VERSION = "20150910";
    protected static final String QUESTION_ENDPOINT = "query";
    protected static final String USER_ENTITIES_ENDPOINT = "userEntities";
    private String serviceUrl;
    private final String apiKey;
    private final SupportedLanguages language;
    private final RecognitionEngine recognitionEngine;
    private AssetFileDescriptor recognizerStartSound;
    private AssetFileDescriptor recognizerStopSound;
    private AssetFileDescriptor recognizerCancelSound;
    private String protocolVersion;
    private boolean writeSoundLog = false;
    private boolean voiceActivityDetectionEnabled = true;
    private boolean normalizeInputSound = false;
    private Proxy proxy;

    public AIConfiguration(String clientAccessToken, SupportedLanguages language, RecognitionEngine recognitionEngine) {
        this.apiKey = clientAccessToken;
        this.language = language;
        this.recognitionEngine = recognitionEngine;
        this.protocolVersion = CURRENT_PROTOCOL_VERSION;
        if (recognitionEngine == RecognitionEngine.Speaktoit && language == SupportedLanguages.Korean) {
            throw new UnsupportedOperationException("Only System recognition supported for Korean language");
        }
        this.serviceUrl = SERVICE_PROD_URL;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getLanguage() {
        return this.language.languageTag;
    }

    public String getApiAiLanguage() {
        return this.language.apiaiLanguage;
    }

    public RecognitionEngine getRecognitionEngine() {
        return this.recognitionEngine;
    }

    public boolean isVoiceActivityDetectionEnabled() {
        return this.voiceActivityDetectionEnabled;
    }

    public void setVoiceActivityDetectionEnabled(boolean voiceActivityDetectionEnabled) {
        this.voiceActivityDetectionEnabled = voiceActivityDetectionEnabled;
    }

    public void setWriteSoundLog(boolean writeSoundLog) {
        this.writeSoundLog = writeSoundLog;
    }

    public boolean isWriteSoundLog() {
        return this.writeSoundLog;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setNormalizeInputSound(boolean normalizeInputSound) {
        this.normalizeInputSound = normalizeInputSound;
    }

    public boolean isNormalizeInputSound() {
        return this.normalizeInputSound;
    }

    public String getQuestionUrl() {
        if (!TextUtils.isEmpty((CharSequence)this.protocolVersion)) {
            return String.format("%s%s?v=%s", this.serviceUrl, QUESTION_ENDPOINT, this.protocolVersion);
        }
        return String.format("%s%s", this.serviceUrl, QUESTION_ENDPOINT);
    }

    String getUserEntitiesEndpoint(String sessionId) {
        if (!TextUtils.isEmpty((CharSequence)this.protocolVersion)) {
            return String.format("%s%s?v=%s&sessionId=%s", this.serviceUrl, USER_ENTITIES_ENDPOINT, this.protocolVersion, sessionId);
        }
        return String.format("%s%s?sessionId=%s", this.serviceUrl, USER_ENTITIES_ENDPOINT, sessionId);
    }

    public AssetFileDescriptor getRecognizerStartSound() {
        return this.recognizerStartSound;
    }

    public void setRecognizerStartSound(AssetFileDescriptor recognizerStartSound) {
        this.recognizerStartSound = recognizerStartSound;
    }

    public AssetFileDescriptor getRecognizerStopSound() {
        return this.recognizerStopSound;
    }

    public void setRecognizerStopSound(AssetFileDescriptor recognizerStopSound) {
        this.recognizerStopSound = recognizerStopSound;
    }

    public AssetFileDescriptor getRecognizerCancelSound() {
        return this.recognizerCancelSound;
    }

    public void setRecognizerCancelSound(AssetFileDescriptor recognizerCancelSound) {
        this.recognizerCancelSound = recognizerCancelSound;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public static enum SupportedLanguages {
        English("en"),
        EnglishUS("en-US", "en"),
        EnglishGB("en-GB", "en"),
        Russian("ru"),
        German("de"),
        Portuguese("pt"),
        PortugueseBrazil("pt-BR"),
        Spanish("es"),
        French("fr"),
        Italian("it"),
        Japanese("ja"),
        Korean("ko"),
        ChineseChina("zh-CN"),
        ChineseHongKong("zh-HK"),
        ChineseTaiwan("zh-TW");

        private final String languageTag;
        private final String apiaiLanguage;

        private SupportedLanguages(String languageTag) {
            this.languageTag = languageTag;
            this.apiaiLanguage = languageTag;
        }

        private SupportedLanguages(String languageTag, String apiaiLanguage) {
            this.languageTag = languageTag;
            this.apiaiLanguage = apiaiLanguage;
        }

        public static SupportedLanguages fromLanguageTag(String languageTag) {
            switch (languageTag) {
                case "en": {
                    return English;
                }
                case "en-US": {
                    return EnglishUS;
                }
                case "en-GB": {
                    return EnglishGB;
                }
                case "ru": {
                    return Russian;
                }
                case "de": {
                    return German;
                }
                case "pt": {
                    return Portuguese;
                }
                case "pt-BR": {
                    return PortugueseBrazil;
                }
                case "es": {
                    return Spanish;
                }
                case "fr": {
                    return French;
                }
                case "it": {
                    return Italian;
                }
                case "ja": {
                    return Japanese;
                }
                case "ko": {
                    return Korean;
                }
                case "zh-CN": {
                    return ChineseChina;
                }
                case "zh-HK": {
                    return ChineseHongKong;
                }
                case "zh-TW": {
                    return ChineseTaiwan;
                }
            }
            return English;
        }
    }

    public static enum RecognitionEngine {
        Google,
        System,
        Speaktoit;

    }
}

