/*
 * Decompiled with CFR 0.152.
 */
package ai.api;

import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

class RequestTask
extends AsyncTask<String, Integer, String> {
    private static final String TAG = RequestTask.class.getName();
    private final URL url;
    private final String accessToken;

    RequestTask(URL url, String accessToken) {
        if (url == null) {
            throw new IllegalArgumentException("url must not be null");
        }
        this.url = url;
        this.accessToken = accessToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doInBackground(String ... params) {
        String payload = params[0];
        if (TextUtils.isEmpty((CharSequence)payload)) {
            throw new IllegalArgumentException("payload argument should not be empty");
        }
        String response = null;
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)this.url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.addRequestProperty("Authorization", "Bearer " + this.accessToken);
            connection.connect();
            BufferedOutputStream outputStream = new BufferedOutputStream(connection.getOutputStream());
            IOUtils.write((String)payload, (OutputStream)outputStream, (Charset)Charsets.UTF_8);
            outputStream.close();
            BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());
            response = IOUtils.toString((InputStream)inputStream, (Charset)Charsets.UTF_8);
            ((InputStream)inputStream).close();
            String string = response;
            return string;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Can't make request to the Speaktoit AI service. Please, check connection settings and API access token.", (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return null;
    }
}

