/*
 * Decompiled with CFR 0.152.
 */
package ai.api;

import ai.api.AIConfiguration;
import ai.api.AIService;
import ai.api.GsonFactory;
import ai.api.SpeaktoitRecognitionRequest;
import ai.api.SpeaktoitRecognitionRequestTask;
import ai.api.model.AIError;
import ai.api.model.AIResponse;
import ai.api.model.QuestionMetadata;
import android.content.Context;
import android.media.AudioRecord;
import java.io.ByteArrayOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;

public class SpeaktoitRecognitionServiceImpl
extends AIService {
    public static final String TAG = SpeaktoitRecognitionServiceImpl.class.getName();
    private static final int SAMPLE_RATE_IN_HZ = 16000;
    private static final int CHANNEL_CONFIG = 16;
    private static final int AUDIO_FORMAT = 2;
    private final AudioRecord mediaRecorder = new AudioRecord(1, 16000, 16, 2, AudioRecord.getMinBufferSize((int)16000, (int)16, (int)2));
    private volatile boolean isRecording = false;
    private ByteArrayOutputStream outputStream;

    protected SpeaktoitRecognitionServiceImpl(Context context, AIConfiguration config) {
        super(config);
    }

    @Override
    public void startListening() {
        this.outputStream = new ByteArrayOutputStream();
        this.mediaRecorder.startRecording();
        this.isRecording = true;
        this.onListeningStarted();
    }

    @Override
    public void stopListening() {
        if (this.isRecording) {
            this.mediaRecorder.stop();
            this.isRecording = false;
            this.onListeningFinished();
            this.sendRequest(this.outputStream.toByteArray());
        }
    }

    @Override
    public void cancel() {
        if (this.isRecording) {
            this.mediaRecorder.stop();
            this.isRecording = false;
            this.onListeningFinished();
        }
    }

    private void sendRequest(byte[] soundData) {
        try {
            URL url = new URL(this.config.getQuestionUrl());
            QuestionMetadata questionMetadata = new QuestionMetadata();
            questionMetadata.setLanguage(this.config.getLanguage());
            questionMetadata.setAgentId(this.config.getAgentId());
            questionMetadata.setTimezone(Calendar.getInstance().getTimeZone().getID());
            SpeaktoitRecognitionRequest speaktoitRecognitionRequest = new SpeaktoitRecognitionRequest();
            speaktoitRecognitionRequest.setMetadata(questionMetadata);
            speaktoitRecognitionRequest.setSoundData(soundData);
            SpeaktoitRecognitionRequestTask requestTask = new SpeaktoitRecognitionRequestTask(url){

                protected void onPostExecute(String stringResult) {
                    try {
                        AIResponse aiResponse = (AIResponse)GsonFactory.getGson().fromJson(stringResult, AIResponse.class);
                        SpeaktoitRecognitionServiceImpl.this.onResult(aiResponse);
                    }
                    catch (Exception e) {
                        AIError aiError = new AIError("Wrong answer from server " + e.toString());
                        SpeaktoitRecognitionServiceImpl.this.onError(aiError);
                    }
                }
            };
            requestTask.execute(new SpeaktoitRecognitionRequest[]{speaktoitRecognitionRequest});
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }
}

