/*
 * Decompiled with CFR 0.152.
 */
package ai.api;

import ai.api.AIConfiguration;
import ai.api.AIServiceException;
import ai.api.GsonFactory;
import ai.api.model.AIRequest;
import ai.api.model.AIResponse;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Calendar;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

public class AIDataService {
    public static final String TAG = AIDataService.class.getName();
    private final AIConfiguration config;

    public AIDataService(AIConfiguration config) {
        this.config = config;
    }

    public AIResponse request(AIRequest request) throws AIServiceException {
        if (request == null) {
            throw new IllegalArgumentException("Request argument must not be null");
        }
        Gson gson = GsonFactory.getGson();
        HttpURLConnection connection = null;
        try {
            AIResponse aiResponse;
            URL url = new URL(this.config.getQuestionUrl());
            request.setLanguage(this.config.getLanguage());
            request.setAgentId(this.config.getAgentId());
            request.setTimezone(Calendar.getInstance().getTimeZone().getID());
            String queryData = gson.toJson((Object)request);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.addRequestProperty("Authorization", "Bearer " + this.config.getApiKey());
            connection.addRequestProperty("ocp-apim-subscription-key", this.config.getSubscriptionKey());
            connection.addRequestProperty("Content-Type", "application/json; charset=utf-8");
            connection.addRequestProperty("Accept", "application/json");
            connection.connect();
            BufferedOutputStream outputStream = new BufferedOutputStream(connection.getOutputStream());
            IOUtils.write((String)queryData, (OutputStream)outputStream, (Charset)Charsets.UTF_8);
            outputStream.close();
            BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());
            String response = IOUtils.toString((InputStream)inputStream, (Charset)Charsets.UTF_8);
            ((InputStream)inputStream).close();
            if (TextUtils.isEmpty((CharSequence)response)) {
                throw new AIServiceException("Empty response from ai service. Please check configuration.");
            }
            AIResponse aIResponse = aiResponse = (AIResponse)gson.fromJson(response, AIResponse.class);
            return aIResponse;
        }
        catch (MalformedURLException e) {
            Log.e((String)TAG, (String)"Malformed url should not be raised", (Throwable)e);
            throw new AIServiceException("Wrong configuration. Please, connect to AI Service support", e);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Can't make request to the Speaktoit AI service. Please, check connection settings and API access token.", (Throwable)e);
            throw new AIServiceException("Can't make request to the AI service. Please, check connection settings and API access token.", e);
        }
        catch (JsonSyntaxException je) {
            throw new AIServiceException("Wrong service answer format. Please, connect to AI Service support", je);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

