/*
 * Decompiled with CFR 0.152.
 */
package ai.api.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;

public class PartialDate {
    public static final Integer UNSPECIFIED_VALUE = null;
    private static final String UNSPECIFIED_YEAR = "uuuu";
    private static final String UNSPECIFIED_MONTH = "uu";
    private static final String UNSPECIFIED_DATE = "uu";
    private static final String UNSPECIFIED_HOUR = "uu";
    private static final String UNSPECIFIED_MINUTE = "uu";
    private final Calendar c;
    private final Set<Integer> unspecifiedFields = new HashSet<Integer>();

    public PartialDate() {
        this.c = Calendar.getInstance();
    }

    public PartialDate(Calendar calendar) {
        this.c = calendar;
    }

    public PartialDate(Date date) {
        this.c = new GregorianCalendar();
        this.c.setTime(date);
    }

    public void set(int field, Integer value) {
        if (value == UNSPECIFIED_VALUE) {
            if (field == 1) {
                this.unspecifiedFields.add(1);
            } else if (field == 2) {
                this.unspecifiedFields.add(2);
            } else if (field >= 3 && field <= 8) {
                this.unspecifiedFields.add(5);
            } else if (field >= 10 && field <= 11) {
                this.unspecifiedFields.add(11);
            } else if (field == 12) {
                this.unspecifiedFields.add(12);
            }
        } else {
            this.unspecifiedFields.remove(field);
            this.c.set(field, value);
        }
    }

    public Integer get(int field) {
        if (field == 1) {
            if (!this.unspecifiedFields.contains(1)) {
                return this.c.get(field);
            }
            return UNSPECIFIED_VALUE;
        }
        if (field == 2) {
            if (!this.unspecifiedFields.contains(2)) {
                return this.c.get(field);
            }
            return UNSPECIFIED_VALUE;
        }
        if (field >= 3 && field <= 8) {
            if (!this.unspecifiedFields.contains(5)) {
                return this.c.get(field);
            }
            return UNSPECIFIED_VALUE;
        }
        if (field >= 10 && field <= 11) {
            if (!this.unspecifiedFields.contains(11)) {
                return this.c.get(field);
            }
            return UNSPECIFIED_VALUE;
        }
        if (field == 12) {
            if (!this.unspecifiedFields.contains(12)) {
                return this.c.get(12);
            }
            return UNSPECIFIED_VALUE;
        }
        return this.c.get(field);
    }

    private String getFieldAsString(int field) {
        if (field == 1) {
            if (this.unspecifiedFields.contains(1)) {
                return UNSPECIFIED_YEAR;
            }
            return String.format("%4d", this.c.get(field));
        }
        if (field == 2) {
            if (this.unspecifiedFields.contains(2)) {
                return "uu";
            }
            return String.format("%02d", this.c.get(field));
        }
        if (field >= 3 && field <= 8) {
            if (this.unspecifiedFields.contains(5)) {
                return "uu";
            }
            return String.format("%02d", this.c.get(field));
        }
        if (field >= 10 && field <= 11) {
            if (this.unspecifiedFields.contains(11)) {
                return "uu";
            }
            return String.format("%02d", this.c.get(field));
        }
        if (field == 12) {
            if (this.unspecifiedFields.contains(12)) {
                return "uu";
            }
            return String.format("%02d", this.c.get(field));
        }
        return String.format("%s", this.c.get(field));
    }

    public String toString() {
        return String.format("%s-%s-%s", this.getFieldAsString(1), this.getFieldAsString(2), this.getFieldAsString(5));
    }
}

