/*
 * Decompiled with CFR 0.152.
 */
package ai.api.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;

public class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static void writeAll(String data, OutputStream outputStream, Charset charset) throws IOException {
        if (data != null && data.length() > 0) {
            outputStream.write(data.getBytes(charset));
        }
    }

    public static String readAll(InputStream inputStream, Charset charset) throws IOException {
        try (InputStreamReader streamReader = new InputStreamReader(inputStream, charset);){
            String string = IOUtils.readAll(streamReader);
            return string;
        }
    }

    public static String readAll(InputStreamReader streamReader) throws IOException {
        StringWriter result = new StringWriter();
        IOUtils.copy(streamReader, result);
        return result.toString();
    }

    private static long copy(Reader reader, Writer writer) throws IOException {
        return IOUtils.copy(reader, writer, new char[4096]);
    }

    private static long copy(Reader reader, Writer writer, char[] buffer) throws IOException {
        assert (buffer != null);
        assert (buffer.length > 0);
        long result = 0L;
        int read = reader.read(buffer);
        while (read > 0) {
            writer.write(buffer, 0, read);
            result += (long)read;
            read = reader.read(buffer);
        }
        return result;
    }
}

