/*
 * Decompiled with CFR 0.152.
 */
package ai.api.util;

import ai.api.util.PartialDate;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.validation.constraints.NotNull;

public final class ParametersConverter {
    public static final String PROTOCOL_DATE_FORMAT = "yyyy-MM-dd";
    public static final String PROTOCOL_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String PROTOCOL_TIME_FORMAT = "HH:mm:ss";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
    private static final DateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss", Locale.US);

    private ParametersConverter() {
    }

    @NotNull
    public static Date parseDateTime(@NotNull String parameter) throws ParseException {
        if (parameter == null) {
            throw new IllegalArgumentException("Parameter must not be null");
        }
        return DATE_TIME_FORMAT.parse(parameter);
    }

    @NotNull
    public static Date parseDate(@NotNull String parameter) throws ParseException {
        if (parameter == null) {
            throw new IllegalArgumentException("Parameter must not be null");
        }
        return DATE_FORMAT.parse(parameter);
    }

    @NotNull
    public static Date parseTime(@NotNull String parameter) throws ParseException {
        if (parameter == null) {
            throw new IllegalArgumentException("Parameter must not be null");
        }
        Calendar timeParameter = Calendar.getInstance();
        timeParameter.setTime(TIME_FORMAT.parse(parameter));
        Calendar taskDueDate = Calendar.getInstance();
        taskDueDate.set(11, timeParameter.get(11));
        taskDueDate.set(12, timeParameter.get(12));
        taskDueDate.set(13, timeParameter.get(13));
        return taskDueDate.getTime();
    }

    @NotNull
    public static PartialDate parsePartialDate(@NotNull String parameter) throws ParseException {
        if (parameter == null) {
            throw new IllegalArgumentException("Parameter must not be empty");
        }
        if (parameter.length() == 0) {
            throw new ParseException("Parameter must not be empty", 0);
        }
        if (parameter.contains("u")) {
            String[] parts = parameter.split("-");
            if (parts.length != 3) {
                throw new ParseException(String.format("Partial date must have 3 parts, but have %s: %s", parts.length, parameter), 0);
            }
            Integer year = ParametersConverter.parsePart(parts[0]);
            Integer month = ParametersConverter.parsePart(parts[1]);
            Integer day = ParametersConverter.parsePart(parts[2]);
            PartialDate result = new PartialDate();
            result.set(1, year);
            result.set(2, month);
            result.set(5, day);
            return result;
        }
        return new PartialDate(DATE_FORMAT.parse(parameter));
    }

    @NotNull
    public static int parseInteger(@NotNull String parameter) throws NumberFormatException {
        return Integer.parseInt(parameter);
    }

    @NotNull
    public static float parseFloat(@NotNull String parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("Parameter must not be empty");
        }
        return Float.parseFloat(parameter);
    }

    @NotNull
    private static Integer parsePart(@NotNull String part) {
        if (part.indexOf(117) >= 0) {
            return PartialDate.UNSPECIFIED_VALUE;
        }
        return Integer.parseInt(part);
    }
}

