/*
 * Decompiled with CFR 0.152.
 */
package ai.api.model;

import ai.api.model.AIContext;
import ai.api.model.QuestionMetadata;
import ai.api.util.StringUtils;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AIRequest
extends QuestionMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    @SerializedName(value="query")
    private String[] query;
    @SerializedName(value="confidence")
    private float[] confidence;
    @SerializedName(value="contexts")
    private List<AIContext> contexts;
    @SerializedName(value="resetContexts")
    private Boolean resetContexts;

    public AIRequest() {
    }

    public AIRequest(String query) {
        this.setQuery(query);
    }

    public void setQuery(String query) {
        if (StringUtils.isEmpty(query)) {
            throw new IllegalStateException("Query must not be empty");
        }
        this.query = new String[]{query};
        this.confidence = null;
    }

    public void setQuery(String[] query, float[] confidence) {
        if (query == null) {
            throw new IllegalStateException("Query array must not be null");
        }
        if (confidence == null && query.length > 1) {
            throw new IllegalStateException("Then confidences array is null, query must be one or zero item length");
        }
        if (confidence != null && query.length != confidence.length) {
            throw new IllegalStateException("Query and confidence arrays must be equals size");
        }
        this.query = query;
        this.confidence = confidence;
    }

    public float[] getConfidence() {
        return this.confidence;
    }

    public void setConfidence(float[] confidence) {
        this.confidence = confidence;
    }

    public void setResetContexts(Boolean resetContexts) {
        this.resetContexts = resetContexts;
    }

    public Boolean getResetContexts() {
        return this.resetContexts;
    }

    public void setContexts(List<AIContext> contexts) {
        this.contexts = contexts;
    }

    public void addContext(AIContext aiContext) {
        if (this.contexts == null) {
            this.contexts = new ArrayList<AIContext>(1);
        }
        this.contexts.add(aiContext);
    }

    @Override
    public String toString() {
        return String.format("AIRequest{query=%s, resetContexts=%s, language='%s', timezone='%s'}", Arrays.toString(this.query), this.resetContexts, this.getLanguage(), this.getTimezone());
    }
}

