/*
 * Decompiled with CFR 0.152.
 */
package ai.api.http;

import ai.api.util.IOUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient {
    private static final Logger Log = LoggerFactory.getLogger(HttpClient.class);
    private static final int CHUNK_LENGTH = 2048;
    private static final int BUFFER_LENGTH = 4096;
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    @NotNull
    private final HttpURLConnection connection;
    private OutputStream os;
    private final String delimiter = "--";
    private final String boundary = "SwA" + Long.toString(System.currentTimeMillis()) + "SwA";
    private boolean writeSoundLog;

    public HttpClient(@NotNull HttpURLConnection connection) {
        this.connection = connection;
    }

    public void connectForMultipart() throws IOException {
        this.connection.setRequestProperty("Connection", "Keep-Alive");
        this.connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
        this.connection.setChunkedStreamingMode(2048);
        this.connection.connect();
        this.os = this.connection.getOutputStream();
    }

    public void addFormPart(@NotNull String paramName, @NotNull String value) throws IOException {
        this.os.write(("--" + this.boundary + "\r\n").getBytes());
        this.os.write("Content-Type: application/json\r\n".getBytes());
        this.os.write(("Content-Disposition: form-data; name=\"" + paramName + "\"\r\n").getBytes());
        this.os.write(("\r\n" + value + "\r\n").getBytes());
    }

    public void addFilePart(@NotNull String paramName, @NotNull String fileName, @NotNull InputStream data) throws IOException {
        this.os.write(("--" + this.boundary + "\r\n").getBytes());
        this.os.write(("Content-Disposition: form-data; name=\"" + paramName + "\"; filename=\"" + fileName + "\"\r\n").getBytes());
        this.os.write("Content-Type: audio/wav\r\n".getBytes());
        this.os.write("\r\n".getBytes());
        Log.debug("Sound write start");
        FileOutputStream outputStream = null;
        if (this.writeSoundLog) {
            File cacheDir = new File(System.getProperty("java.io.tmpdir"));
            if (!cacheDir.exists()) {
                cacheDir.mkdirs();
            }
            Log.debug(cacheDir.getAbsolutePath());
            File soundFile = new File(cacheDir, "log.wav");
            outputStream = new FileOutputStream(soundFile, false);
        }
        byte[] buffer = new byte[4096];
        int bytesActuallyRead = data.read(buffer, 0, buffer.length);
        while (bytesActuallyRead >= 0) {
            if (bytesActuallyRead > 0) {
                this.os.write(buffer, 0, bytesActuallyRead);
                if (this.writeSoundLog) {
                    outputStream.write(buffer, 0, bytesActuallyRead);
                }
            }
            bytesActuallyRead = data.read(buffer, 0, buffer.length);
        }
        if (this.writeSoundLog) {
            outputStream.close();
        }
        Log.debug("Sound write finished");
        this.os.write("\r\n".getBytes());
    }

    public void finishMultipart() throws IOException {
        this.os.write(("--" + this.boundary + "--" + "\r\n").getBytes());
        this.os.close();
    }

    @NotNull
    public String getResponse() throws IOException {
        BufferedInputStream inputStream = new BufferedInputStream(this.connection.getInputStream());
        String response = IOUtils.readAll(inputStream, DEFAULT_CHARSET);
        ((InputStream)inputStream).close();
        return response;
    }

    public String getErrorString() {
        try {
            BufferedInputStream inputStream = new BufferedInputStream(this.connection.getErrorStream());
            String response = IOUtils.readAll(inputStream, DEFAULT_CHARSET);
            ((InputStream)inputStream).close();
            return response;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setWriteSoundLog(boolean writeSoundLog) {
        this.writeSoundLog = writeSoundLog;
    }
}

