/*
 * Decompiled with CFR 0.152.
 */
package ai.api;

import ai.api.AIConfiguration;
import ai.api.AIServiceContext;
import ai.api.AIServiceContextBuilder;
import ai.api.AIServiceException;
import ai.api.GsonFactory;
import ai.api.RequestExtras;
import ai.api.http.HttpClient;
import ai.api.model.AIContext;
import ai.api.model.AIRequest;
import ai.api.model.AIResponse;
import ai.api.model.Entity;
import ai.api.model.Status;
import ai.api.util.IOUtils;
import ai.api.util.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIDataService {
    private static final Logger Log = LoggerFactory.getLogger(AIDataService.class);
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    @NotNull
    private final AIConfiguration config;
    @NotNull
    private final AIServiceContext serviceContext;
    @NotNull
    private final Gson gson = GsonFactory.getDefaultFactory().getGson();

    public AIDataService(@NotNull AIConfiguration config, AIServiceContext serviceContext) {
        if (config == null) {
            throw new IllegalArgumentException("config should not be null");
        }
        this.config = config.clone();
        this.serviceContext = serviceContext == null ? new AIServiceContextBuilder().generateSessionId().build() : serviceContext;
    }

    public AIDataService(@NotNull AIConfiguration config) {
        this(config, null);
    }

    @NotNull
    public AIServiceContext getContext() {
        return this.serviceContext;
    }

    public AIResponse request(@NotNull AIRequest request) throws AIServiceException {
        return this.request(request, null);
    }

    @NotNull
    public AIResponse request(@NotNull AIRequest request, RequestExtras requestExtras) throws AIServiceException {
        if (request == null) {
            throw new IllegalArgumentException("Request argument must not be null");
        }
        Log.debug("Start request");
        try {
            request.setLanguage(this.config.getApiAiLanguage());
            request.setSessionId(this.serviceContext.getSessionId());
            request.setTimezone(Calendar.getInstance().getTimeZone().getID());
            Map<String, String> additionalHeaders = null;
            if (requestExtras != null) {
                this.fillRequest(request, requestExtras);
                additionalHeaders = requestExtras.getAdditionalHeaders();
            }
            String queryData = this.gson.toJson((Object)request);
            String response = this.doTextRequest(this.config.getQuestionUrl(this.serviceContext.getSessionId()), queryData, additionalHeaders);
            if (StringUtils.isEmpty(response)) {
                throw new AIServiceException("Empty response from ai service. Please check configuration and Internet connection.");
            }
            Log.debug("Response json: " + response.replaceAll("[\r\n]+", " "));
            AIResponse aiResponse = (AIResponse)this.gson.fromJson(response, AIResponse.class);
            if (aiResponse == null) {
                throw new AIServiceException("API.AI response parsed as null. Check debug log for details.");
            }
            if (aiResponse.isError()) {
                throw new AIServiceException(aiResponse);
            }
            aiResponse.cleanup();
            return aiResponse;
        }
        catch (MalformedURLException e) {
            Log.error("Malformed url should not be raised", (Throwable)e);
            throw new AIServiceException("Wrong configuration. Please, connect to API.AI Service support", e);
        }
        catch (JsonSyntaxException je) {
            throw new AIServiceException("Wrong service answer format. Please, connect to API.AI Service support", je);
        }
    }

    @NotNull
    public AIResponse voiceRequest(@NotNull InputStream voiceStream) throws AIServiceException {
        return this.voiceRequest(voiceStream, new RequestExtras());
    }

    @NotNull
    public AIResponse voiceRequest(@NotNull InputStream voiceStream, List<AIContext> aiContexts) throws AIServiceException {
        return this.voiceRequest(voiceStream, new RequestExtras(aiContexts, null));
    }

    @NotNull
    public AIResponse voiceRequest(@NotNull InputStream voiceStream, RequestExtras requestExtras) throws AIServiceException {
        Log.debug("Start voice request");
        try {
            AIRequest request = new AIRequest();
            request.setLanguage(this.config.getApiAiLanguage());
            request.setSessionId(this.serviceContext.getSessionId());
            request.setTimezone(Calendar.getInstance().getTimeZone().getID());
            Map<String, String> additionalHeaders = null;
            if (requestExtras != null) {
                this.fillRequest(request, requestExtras);
                additionalHeaders = requestExtras.getAdditionalHeaders();
            }
            String queryData = this.gson.toJson((Object)request);
            Log.debug("Request json: " + queryData);
            String response = this.doSoundRequest(voiceStream, queryData, additionalHeaders);
            if (StringUtils.isEmpty(response)) {
                throw new AIServiceException("Empty response from ai service. Please check configuration.");
            }
            Log.debug("Response json: " + response);
            AIResponse aiResponse = (AIResponse)this.gson.fromJson(response, AIResponse.class);
            if (aiResponse == null) {
                throw new AIServiceException("API.AI response parsed as null. Check debug log for details.");
            }
            if (aiResponse.isError()) {
                throw new AIServiceException(aiResponse);
            }
            aiResponse.cleanup();
            return aiResponse;
        }
        catch (MalformedURLException e) {
            Log.error("Malformed url should not be raised", (Throwable)e);
            throw new AIServiceException("Wrong configuration. Please, connect to AI Service support", e);
        }
        catch (JsonSyntaxException je) {
            throw new AIServiceException("Wrong service answer format. Please, connect to API.AI Service support", je);
        }
    }

    public boolean resetContexts() {
        AIRequest cleanRequest = new AIRequest();
        cleanRequest.setQuery("empty_query_for_resetting_contexts");
        cleanRequest.setResetContexts(true);
        try {
            AIResponse response = this.request(cleanRequest);
            return !response.isError();
        }
        catch (AIServiceException e) {
            Log.error("Exception while contexts clean.", (Throwable)e);
            return false;
        }
    }

    public AIResponse uploadUserEntity(Entity userEntity) throws AIServiceException {
        return this.uploadUserEntities(Collections.singleton(userEntity));
    }

    public AIResponse uploadUserEntities(Collection<Entity> userEntities) throws AIServiceException {
        if (userEntities == null || userEntities.size() == 0) {
            throw new AIServiceException("Empty entities list");
        }
        String requestData = this.gson.toJson(userEntities);
        try {
            String response = this.doTextRequest(this.config.getUserEntitiesEndpoint(this.serviceContext.getSessionId()), requestData);
            if (StringUtils.isEmpty(response)) {
                throw new AIServiceException("Empty response from ai service. Please check configuration and Internet connection.");
            }
            Log.debug("Response json: " + response);
            AIResponse aiResponse = (AIResponse)this.gson.fromJson(response, AIResponse.class);
            if (aiResponse == null) {
                throw new AIServiceException("API.AI response parsed as null. Check debug log for details.");
            }
            if (aiResponse.isError()) {
                throw new AIServiceException(aiResponse);
            }
            aiResponse.cleanup();
            return aiResponse;
        }
        catch (MalformedURLException e) {
            Log.error("Malformed url should not be raised", (Throwable)e);
            throw new AIServiceException("Wrong configuration. Please, connect to AI Service support", e);
        }
        catch (JsonSyntaxException je) {
            throw new AIServiceException("Wrong service answer format. Please, connect to API.AI Service support", je);
        }
    }

    protected String doTextRequest(String requestJson) throws MalformedURLException, AIServiceException {
        return this.doTextRequest(this.config.getQuestionUrl(this.serviceContext.getSessionId()), requestJson);
    }

    protected String doTextRequest(String endpoint, String requestJson) throws MalformedURLException, AIServiceException {
        return this.doTextRequest(endpoint, requestJson, null);
    }

    protected String doTextRequest(@NotNull String endpoint, @NotNull String requestJson, Map<String, String> additionalHeaders) throws MalformedURLException, AIServiceException {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(endpoint);
            String queryData = requestJson;
            Log.debug("Request json: " + queryData);
            connection = this.config.getProxy() != null ? (HttpURLConnection)url.openConnection(this.config.getProxy()) : (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.addRequestProperty("Authorization", "Bearer " + this.config.getApiKey());
            connection.addRequestProperty("Content-Type", "application/json; charset=utf-8");
            connection.addRequestProperty("Accept", "application/json");
            if (additionalHeaders != null) {
                for (Map.Entry<String, String> entry : additionalHeaders.entrySet()) {
                    connection.addRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            connection.connect();
            BufferedOutputStream outputStream = new BufferedOutputStream(connection.getOutputStream());
            IOUtils.writeAll(queryData, outputStream, DEFAULT_CHARSET);
            outputStream.close();
            BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());
            String response = IOUtils.readAll(inputStream, DEFAULT_CHARSET);
            ((InputStream)inputStream).close();
            String string = response;
            return string;
        }
        catch (IOException e) {
            if (connection != null) {
                block13: {
                    InputStream errorStream = connection.getErrorStream();
                    if (errorStream == null) break block13;
                    String errorString = IOUtils.readAll(errorStream, DEFAULT_CHARSET);
                    Log.debug(errorString);
                    String string = errorString;
                    return string;
                }
                try {
                    throw new AIServiceException("Can't connect to the api.ai service.", e);
                }
                catch (IOException ex) {
                    Log.warn("Can't read error response", (Throwable)ex);
                }
            }
            Log.error("Can't make request to the API.AI service. Please, check connection settings and API access token.", (Throwable)e);
            throw new AIServiceException("Can't make request to the API.AI service. Please, check connection settings and API access token.", e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    protected String doSoundRequest(@NotNull InputStream voiceStream, @NotNull String queryData) throws MalformedURLException, AIServiceException {
        return this.doSoundRequest(voiceStream, queryData, null);
    }

    protected String doSoundRequest(@NotNull InputStream voiceStream, @NotNull String queryData, Map<String, String> additionalHeaders) throws MalformedURLException, AIServiceException {
        HttpURLConnection connection = null;
        HttpClient httpClient = null;
        try {
            String response;
            URL url = new URL(this.config.getQuestionUrl(this.serviceContext.getSessionId()));
            Log.debug("Connecting to {}", (Object)url);
            connection = this.config.getProxy() != null ? (HttpURLConnection)url.openConnection(this.config.getProxy()) : (HttpURLConnection)url.openConnection();
            connection.addRequestProperty("Authorization", "Bearer " + this.config.getApiKey());
            connection.addRequestProperty("Accept", "application/json");
            if (additionalHeaders != null) {
                for (Map.Entry<String, String> entry : additionalHeaders.entrySet()) {
                    connection.addRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            connection.setRequestMethod("POST");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            httpClient = new HttpClient(connection);
            httpClient.setWriteSoundLog(this.config.isWriteSoundLog());
            httpClient.connectForMultipart();
            httpClient.addFormPart("request", queryData);
            httpClient.addFilePart("voiceData", "voice.wav", voiceStream);
            httpClient.finishMultipart();
            String string = response = httpClient.getResponse();
            return string;
        }
        catch (IOException e) {
            if (httpClient != null) {
                String errorString = httpClient.getErrorString();
                Log.debug(errorString);
                if (!StringUtils.isEmpty(errorString)) {
                    String string = errorString;
                    return string;
                }
                if (e instanceof HttpRetryException) {
                    AIResponse aIResponse = new AIResponse();
                    int code = ((HttpRetryException)e).responseCode();
                    Status status = Status.fromResponseCode(code);
                    status.setErrorDetails(((HttpRetryException)e).getReason());
                    aIResponse.setStatus(status);
                    throw new AIServiceException(aIResponse);
                }
            }
            Log.error("Can't make request to the API.AI service. Please, check connection settings and API.AI keys.", (Throwable)e);
            throw new AIServiceException("Can't make request to the API.AI service. Please, check connection settings and API.AI keys.", e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private void fillRequest(@NotNull AIRequest request, @NotNull RequestExtras requestExtras) {
        if (requestExtras.hasContexts()) {
            request.setContexts(requestExtras.getContexts());
        }
        if (requestExtras.hasEntities()) {
            request.setEntities(requestExtras.getEntities());
        }
        if (requestExtras.getLocation() != null) {
            request.setLocation(requestExtras.getLocation());
        }
    }
}

