/*
 * Decompiled with CFR 0.152.
 */
package ae.teletronics.solr.plugin;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.plugin.SolrCoreAware;

public class ThreadRenamingRequestHandler
extends RequestHandlerBase
implements SolrCoreAware {
    private ConcurrentMap<Thread, String> executingThreads = new ConcurrentHashMap<Thread, String>();
    private String delegateName;
    private SolrRequestHandler delegate;

    public void init(NamedList initArgs) {
        this.delegateName = String.valueOf(initArgs.get("delegate"));
    }

    public void inform(SolrCore core) {
        this.delegate = core.getRequestHandler(this.delegateName);
        if (this.delegate == null) {
            throw new IllegalArgumentException("Solr request handler delegate not found! Please check your <str name=\"delegate\">...</str> init argument");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequestBody(SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        Thread thread = Thread.currentThread();
        String originalThreadName = thread.getName();
        try {
            try {
                this.executingThreads.put(thread, originalThreadName);
                thread.setName(String.format("%s (Start: %s): %s", this.delegate.getName(), DateTimeFormatter.ISO_LOCAL_TIME.format(LocalTime.now()), SolrParams.toMap((NamedList)solrQueryRequest.getParams().toNamedList()).toString()));
            }
            catch (NullPointerException | SecurityException runtimeException) {
                // empty catch block
            }
            this.delegate.handleRequest(solrQueryRequest, solrQueryResponse);
        }
        finally {
            this.executingThreads.remove(thread);
            try {
                thread.setName(originalThreadName);
            }
            catch (SecurityException securityException) {}
        }
    }

    public int getRunningRequestCount() {
        return this.executingThreads.size();
    }

    public List<String> getRunningRequests() {
        return this.executingThreads.keySet().stream().map(Thread::getName).collect(Collectors.toList());
    }

    public String getName() {
        return "ThreadRenamingRequestHandlerDelegate";
    }

    public String getDescription() {
        return "Thread renaming request handler delegate";
    }

    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    public void initializeMetrics(SolrMetricManager manager, String registryName, String scope) {
        super.initializeMetrics(manager, registryName, scope);
        manager.registerGauge((SolrInfoBean)this, registryName, () -> this.executingThreads.size(), true, "runningRequests", new String[]{this.getCategory().toString(), scope});
    }
}

