/*
 * Decompiled with CFR 0.152.
 */
package ae.teletronics.solr.plugin;

import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryInspectorHandler
extends RequestHandlerBase
implements SolrCoreAware {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private SolrCore core;
    private CoreContainer coreContainer;

    public void handleRequestBody(SolrQueryRequest request, SolrQueryResponse response) {
        Accountable memory;
        if (this.coreContainer != null) {
            memory = this.inspectCoreContainer(this.coreContainer);
            if (request.getParams().getBool("dumpToStdOut", false)) {
                log.info(Accountables.toString((Accountable)memory));
            }
        } else {
            memory = () -> 0L;
        }
        Map<String, ?> map = MemoryInspectorHandler.toMap(memory);
        response.add("Memory dump", map);
    }

    private static Map<String, ?> toMap(Accountable accountable) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put(accountable.toString(), RamUsageEstimator.humanReadableUnits((long)accountable.ramBytesUsed(), (DecimalFormat)new DecimalFormat("0.0#", DecimalFormatSymbols.getInstance(Locale.ROOT))));
        Collection children = accountable.getChildResources().stream().map(a -> MemoryInspectorHandler.toMap(a)).collect(Collectors.toList());
        if (!children.isEmpty()) {
            result.put("children", children);
        }
        return result;
    }

    private Accountable inspectCoreContainer(CoreContainer coreContainer) {
        Collection<Object> cores = coreContainer.getCores() != null ? coreContainer.getCores() : Collections.emptyList();
        Collection children = cores.stream().map(c -> this.inspectCore((SolrCore)c)).collect(Collectors.toList());
        String name = String.format("Solr cores (count: %s)", children.size());
        return Accountables.namedAccountable((String)name, (Collection)children, (long)children.stream().mapToLong(Accountable::ramBytesUsed).sum());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Accountable inspectCore(SolrCore core) {
        ArrayList<Accountable> children = new ArrayList<Accountable>();
        RefCounted searcher = core.getSearcher();
        try {
            children.add(this.inspectSearcher((SolrIndexSearcher)searcher.get()));
        }
        finally {
            searcher.decref();
        }
        String name = String.format("Core '%s' (codec: '%s', lucene match version: '%s')", core.getName(), core.getCodec().getName(), core.getSolrConfig().luceneMatchVersion);
        return Accountables.namedAccountable((String)name, children, (long)children.stream().mapToLong(Accountable::ramBytesUsed).sum());
    }

    private Accountable inspectSearcher(SolrIndexSearcher searcher) {
        ArrayList<Accountable> children = new ArrayList<Accountable>();
        children.add(this.inspectIndexReader((IndexReader)searcher.getIndexReader()));
        String name = String.format("Searcher '%s' (numDocs: %s, maxDocs: %s)", searcher.getName(), searcher.numDocs(), searcher.maxDoc());
        return Accountables.namedAccountable((String)name, children, (long)children.stream().mapToLong(Accountable::ramBytesUsed).sum());
    }

    private Accountable inspectIndexReader(IndexReader indexReader) {
        Accountable result;
        if (indexReader instanceof FilterLeafReader) {
            indexReader = FilterLeafReader.unwrap((LeafReader)((LeafReader)indexReader));
        }
        IndexReader unwrappedReader = indexReader;
        if (indexReader instanceof Accountable) {
            result = (Accountable)indexReader;
        } else if (indexReader.leaves().size() == 0) {
            result = Accountables.namedAccountable((String)unwrappedReader.toString(), (long)0L);
        } else {
            Collection children = indexReader.leaves().stream().map(lrc -> {
                LeafReader reader = lrc.reader();
                if (reader == unwrappedReader) {
                    return Accountables.namedAccountable((String)unwrappedReader.toString(), (long)0L);
                }
                return this.inspectIndexReader((IndexReader)reader);
            }).collect(Collectors.toList());
            String name = String.format("IndexReader '%s', segments: %s", indexReader.getClass().getName(), indexReader.leaves().size());
            result = Accountables.namedAccountable((String)name, (Collection)children, (long)children.stream().mapToLong(Accountable::ramBytesUsed).sum());
        }
        return result;
    }

    public String getName() {
        return "MemoryInspectorHandler";
    }

    public String getVersion() {
        return "1.0";
    }

    public String getDescription() {
        return "Inspects solr memory usage";
    }

    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.ADMIN;
    }

    public String getSource() {
        return null;
    }

    public URL[] getDocs() {
        return new URL[0];
    }

    public NamedList getStatistics() {
        SimpleOrderedMap result = new SimpleOrderedMap();
        long memoryUsage = this.core != null ? this.inspectCore(this.core).ramBytesUsed() : 0L;
        result.add("Memory usage", (Object)memoryUsage);
        return result;
    }

    public void inform(SolrCore solrCore) {
        this.core = solrCore;
        this.coreContainer = solrCore.getCoreDescriptor().getCoreContainer();
    }
}

