/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Authentication;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Registration;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

class PacketReader {
    private static final String PROPERTIES_NAMESPACE = "http://www.jivesoftware.com/xmlns/xmpp/properties";
    private Thread readerThread;
    private Thread listenerThread;
    private XMPPConnection connection;
    private XmlPullParser parser;
    private boolean done = false;
    protected List collectors = new ArrayList();
    private List listeners = new ArrayList();
    protected List connectionListeners = new ArrayList();
    private String connectionID = null;
    private Object connectionIDLock = new Object();

    protected PacketReader(XMPPConnection connection) {
        this.connection = connection;
        this.readerThread = new Thread(){

            public void run() {
                PacketReader.this.parsePackets();
            }
        };
        this.readerThread.setName("Smack Packet Reader");
        this.readerThread.setDaemon(true);
        this.listenerThread = new Thread(){

            public void run() {
                PacketReader.this.processListeners();
            }
        };
        this.listenerThread.setName("Smack Listener Processor");
        this.listenerThread.setDaemon(true);
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance("org.xmlpull.mxp1.MXParserFactory", null);
            factory.setNamespaceAware(true);
            this.parser = factory.newPullParser();
            this.parser.setInput(connection.reader);
        }
        catch (XmlPullParserException xppe) {
            xppe.printStackTrace();
        }
    }

    public PacketCollector createPacketCollector(PacketFilter packetFilter) {
        PacketCollector packetCollector = new PacketCollector(this, packetFilter);
        return packetCollector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPacketListener(PacketListener packetListener, PacketFilter packetFilter) {
        ListenerWrapper wrapper = new ListenerWrapper(this, packetListener, packetFilter);
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePacketListener(PacketListener packetListener) {
        List list = this.listeners;
        synchronized (list) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ListenerWrapper wrapper = (ListenerWrapper)this.listeners.get(i);
                if (wrapper == null || !wrapper.packetListener.equals(packetListener)) continue;
                this.listeners.set(i, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup() throws XMPPException {
        this.readerThread.start();
        this.listenerThread.start();
        try {
            Object object = this.connectionIDLock;
            synchronized (object) {
                this.connectionIDLock.wait(SmackConfiguration.getPacketReplyTimeout());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.connectionID == null) {
            throw new XMPPException("Connection failed. No response from server.");
        }
        this.connection.connectionID = this.connectionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!this.done) {
            List list = this.connectionListeners;
            synchronized (list) {
                ArrayList listenersCopy = new ArrayList(this.connectionListeners);
                Iterator i = listenersCopy.iterator();
                while (i.hasNext()) {
                    ConnectionListener listener = (ConnectionListener)i.next();
                    listener.connectionClosed();
                }
            }
        }
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyConnectionError(Exception e) {
        this.done = true;
        this.connection.close();
        List list = this.connectionListeners;
        synchronized (list) {
            ArrayList listenersCopy = new ArrayList(this.connectionListeners);
            Iterator i = listenersCopy.iterator();
            while (i.hasNext()) {
                ConnectionListener listener = (ConnectionListener)i.next();
                listener.connectionClosedOnError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processListeners() {
        boolean processedPacket = false;
        while (!this.done) {
            int i;
            List list = this.listeners;
            synchronized (list) {
                if (this.listeners.size() > 0) {
                    for (i = this.listeners.size() - 1; i >= 0; --i) {
                        if (this.listeners.get(i) != null) continue;
                        this.listeners.remove(i);
                    }
                }
            }
            processedPacket = false;
            int size = this.listeners.size();
            for (i = 0; i < size; ++i) {
                ListenerWrapper wrapper = (ListenerWrapper)this.listeners.get(i);
                if (wrapper == null) continue;
                processedPacket = processedPacket || wrapper.notifyListener();
            }
            if (processedPacket) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePackets() {
        block18: {
            try {
                int eventType = this.parser.getEventType();
                do {
                    if (eventType == 2) {
                        if (this.parser.getName().equals("message")) {
                            this.processPacket(this.parseMessage(this.parser));
                        } else if (this.parser.getName().equals("iq")) {
                            this.processPacket(this.parseIQ(this.parser));
                        } else if (this.parser.getName().equals("presence")) {
                            this.processPacket(this.parsePresence(this.parser));
                        } else if (this.parser.getName().equals("stream") && "jabber:client".equals(this.parser.getNamespace(null))) {
                            for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                                if (this.parser.getAttributeName(i).equals("id")) {
                                    this.connectionID = this.parser.getAttributeValue(i);
                                    Object object = this.connectionIDLock;
                                    synchronized (object) {
                                        this.connectionIDLock.notifyAll();
                                        continue;
                                    }
                                }
                                if (!this.parser.getAttributeName(i).equals("from")) continue;
                                this.connection.host = this.parser.getAttributeValue(i);
                            }
                        }
                    } else if (eventType == 3 && this.parser.getName().equals("stream")) {
                        this.connection.close();
                    }
                    eventType = this.parser.next();
                } while (!this.done && eventType != 1);
            }
            catch (Exception e) {
                if (this.done) break block18;
                this.notifyConnectionError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPacket(Packet packet) {
        int i;
        if (packet == null) {
            return;
        }
        List list = this.collectors;
        synchronized (list) {
            for (i = this.collectors.size() - 1; i >= 0; --i) {
                if (this.collectors.get(i) != null) continue;
                this.collectors.remove(i);
            }
        }
        int size = this.collectors.size();
        for (i = 0; i < size; ++i) {
            PacketCollector collector = (PacketCollector)this.collectors.get(i);
            if (collector == null) continue;
            collector.processPacket(packet);
        }
    }

    private IQ parseIQ(XmlPullParser parser) throws Exception {
        Packet iqPacket = null;
        String id = parser.getAttributeValue("", "id");
        String to = parser.getAttributeValue("", "to");
        String from = parser.getAttributeValue("", "from");
        IQ.Type type = IQ.Type.fromString(parser.getAttributeValue("", "type"));
        XMPPError error = null;
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String elementName = parser.getName();
                String namespace = parser.getNamespace();
                if (elementName.equals("error")) {
                    error = this.parseError(parser);
                    continue;
                }
                if (elementName.equals("query") && namespace.equals("jabber:iq:auth")) {
                    iqPacket = this.parseAuthentication(parser);
                    continue;
                }
                if (elementName.equals("query") && namespace.equals("jabber:iq:roster")) {
                    iqPacket = this.parseRoster(parser);
                    continue;
                }
                if (elementName.equals("query") && namespace.equals("jabber:iq:register")) {
                    iqPacket = this.parseRegistration(parser);
                    continue;
                }
                Object provider = ProviderManager.getIQProvider(elementName, namespace);
                if (provider == null) continue;
                if (provider instanceof IQProvider) {
                    iqPacket = ((IQProvider)provider).parseIQ(parser);
                    continue;
                }
                if (!(provider instanceof Class)) continue;
                iqPacket = (IQ)PacketParserUtils.parseWithIntrospection(elementName, (Class)provider, parser);
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("iq")) continue;
            done = true;
        }
        if (iqPacket == null) {
            if (IQ.Type.GET == type || IQ.Type.SET == type) {
                iqPacket = new IQ(){

                    public String getChildElementXML() {
                        return null;
                    }
                };
                iqPacket.setPacketID(id);
                iqPacket.setTo(from);
                iqPacket.setFrom(to);
                ((IQ)iqPacket).setType(IQ.Type.ERROR);
                iqPacket.setError(new XMPPError(501, "feature-not-implemented"));
                this.connection.sendPacket(iqPacket);
                return null;
            }
            iqPacket = new IQ(){

                public String getChildElementXML() {
                    return null;
                }
            };
        }
        iqPacket.setPacketID(id);
        iqPacket.setTo(to);
        iqPacket.setFrom(from);
        ((IQ)iqPacket).setType(type);
        iqPacket.setError(error);
        return iqPacket;
    }

    private Authentication parseAuthentication(XmlPullParser parser) throws Exception {
        Authentication authentication = new Authentication();
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("username")) {
                    authentication.setUsername(parser.nextText());
                    continue;
                }
                if (parser.getName().equals("password")) {
                    authentication.setPassword(parser.nextText());
                    continue;
                }
                if (parser.getName().equals("digest")) {
                    authentication.setDigest(parser.nextText());
                    continue;
                }
                if (!parser.getName().equals("resource")) continue;
                authentication.setResource(parser.nextText());
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("query")) continue;
            done = true;
        }
        return authentication;
    }

    private RosterPacket parseRoster(XmlPullParser parser) throws Exception {
        RosterPacket roster = new RosterPacket();
        boolean done = false;
        RosterPacket.Item item = null;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("item")) {
                    String jid = parser.getAttributeValue("", "jid");
                    String name = parser.getAttributeValue("", "name");
                    item = new RosterPacket.Item(jid, name);
                    String ask = parser.getAttributeValue("", "ask");
                    RosterPacket.ItemStatus status = RosterPacket.ItemStatus.fromString(ask);
                    item.setItemStatus(status);
                    String subscription = parser.getAttributeValue("", "subscription");
                    RosterPacket.ItemType type = RosterPacket.ItemType.fromString(subscription);
                    item.setItemType(type);
                }
                if (!parser.getName().equals("group")) continue;
                String groupName = parser.nextText();
                item.addGroupName(groupName);
                continue;
            }
            if (eventType != 3) continue;
            if (parser.getName().equals("item")) {
                roster.addRosterItem(item);
            }
            if (!parser.getName().equals("query")) continue;
            done = true;
        }
        return roster;
    }

    private Registration parseRegistration(XmlPullParser parser) throws Exception {
        Registration registration = new Registration();
        HashMap<String, String> fields = null;
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("username")) {
                    registration.setUsername(parser.nextText());
                    continue;
                }
                if (parser.getName().equals("password")) {
                    registration.setPassword(parser.nextText());
                    continue;
                }
                if (parser.getNamespace().equals("jabber:iq:register")) {
                    String name = parser.getName();
                    String value = "";
                    if (fields == null) {
                        fields = new HashMap<String, String>();
                    }
                    if (parser.next() == 4) {
                        value = parser.getText();
                    }
                    if (!name.equals("instructions")) {
                        fields.put(name, value);
                        continue;
                    }
                    registration.setInstructions(value);
                    continue;
                }
                registration.addExtension(PacketParserUtils.parsePacketExtension(parser.getName(), parser.getNamespace(), parser));
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("query")) continue;
            done = true;
        }
        registration.setAttributes(fields);
        return registration;
    }

    private XMPPError parseError(XmlPullParser parser) throws Exception {
        String errorCode = null;
        String message = null;
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            if (!parser.getAttributeName(i).equals("code")) continue;
            errorCode = parser.getAttributeValue("", "code");
        }
        try {
            message = parser.nextText();
        }
        catch (XmlPullParserException ex) {
            // empty catch block
        }
        while (parser.getEventType() != 3 || !parser.getName().equals("error")) {
            parser.next();
        }
        return new XMPPError(Integer.parseInt(errorCode), message);
    }

    private Packet parseMessage(XmlPullParser parser) throws Exception {
        Message message = new Message();
        String id = parser.getAttributeValue("", "id");
        message.setPacketID(id == null ? "ID_NOT_AVAILABLE" : id);
        message.setTo(parser.getAttributeValue("", "to"));
        message.setFrom(parser.getAttributeValue("", "from"));
        message.setType(Message.Type.fromString(parser.getAttributeValue("", "type")));
        boolean done = false;
        String subject = null;
        String body = null;
        String thread = null;
        Map properties = null;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String elementName = parser.getName();
                String namespace = parser.getNamespace();
                if (elementName.equals("subject")) {
                    if (subject != null) continue;
                    subject = parser.nextText();
                    continue;
                }
                if (elementName.equals("body")) {
                    if (body != null) continue;
                    body = parser.nextText();
                    continue;
                }
                if (elementName.equals("thread")) {
                    if (thread != null) continue;
                    thread = parser.nextText();
                    continue;
                }
                if (elementName.equals("error")) {
                    message.setError(this.parseError(parser));
                    continue;
                }
                if (elementName.equals("properties") && namespace.equals(PROPERTIES_NAMESPACE)) {
                    properties = this.parseProperties(parser);
                    continue;
                }
                message.addExtension(PacketParserUtils.parsePacketExtension(elementName, namespace, parser));
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("message")) continue;
            done = true;
        }
        message.setSubject(subject);
        message.setBody(body);
        message.setThread(thread);
        if (properties != null) {
            Iterator i = properties.keySet().iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                message.setProperty(name, properties.get(name));
            }
        }
        return message;
    }

    private Presence parsePresence(XmlPullParser parser) throws Exception {
        Presence.Type type = Presence.Type.fromString(parser.getAttributeValue("", "type"));
        Presence presence = new Presence(type);
        presence.setTo(parser.getAttributeValue("", "to"));
        presence.setFrom(parser.getAttributeValue("", "from"));
        String id = parser.getAttributeValue("", "id");
        presence.setPacketID(id == null ? "ID_NOT_AVAILABLE" : id);
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String elementName = parser.getName();
                String namespace = parser.getNamespace();
                if (elementName.equals("status")) {
                    presence.setStatus(parser.nextText());
                    continue;
                }
                if (elementName.equals("priority")) {
                    try {
                        int priority = Integer.parseInt(parser.nextText());
                        presence.setPriority(priority);
                    }
                    catch (NumberFormatException nfe) {}
                    continue;
                }
                if (elementName.equals("show")) {
                    presence.setMode(Presence.Mode.fromString(parser.nextText()));
                    continue;
                }
                if (elementName.equals("error")) {
                    presence.setError(this.parseError(parser));
                    continue;
                }
                if (elementName.equals("properties") && namespace.equals(PROPERTIES_NAMESPACE)) {
                    Map properties = this.parseProperties(parser);
                    Iterator i = properties.keySet().iterator();
                    while (i.hasNext()) {
                        String name = (String)i.next();
                        presence.setProperty(name, properties.get(name));
                    }
                    continue;
                }
                presence.addExtension(PacketParserUtils.parsePacketExtension(elementName, namespace, parser));
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("presence")) continue;
            done = true;
        }
        return presence;
    }

    private Map parseProperties(XmlPullParser parser) throws Exception {
        HashMap<String, Integer> properties = new HashMap<String, Integer>();
        block2: while (true) {
            int eventType;
            if ((eventType = parser.next()) == 2 && parser.getName().equals("property")) {
                boolean done = false;
                String name = null;
                String type = null;
                String valueText = null;
                Object value = null;
                while (true) {
                    if (done) continue block2;
                    eventType = parser.next();
                    if (eventType == 2) {
                        String elementName = parser.getName();
                        String namespace = parser.getNamespace();
                        if (elementName.equals("name")) {
                            name = parser.nextText();
                            continue;
                        }
                        if (!elementName.equals("value")) continue;
                        type = parser.getAttributeValue("", "type");
                        valueText = parser.nextText();
                        continue;
                    }
                    if (eventType != 3 || !parser.getName().equals("property")) continue;
                    if ("integer".equals(type)) {
                        value = new Integer(valueText);
                    } else if ("long".equals(type)) {
                        value = new Long(valueText);
                    } else if ("float".equals(type)) {
                        value = new Float(valueText);
                    } else if ("double".equals(type)) {
                        value = new Double(valueText);
                    } else if ("boolean".equals(type)) {
                        value = new Boolean(valueText);
                    } else if ("string".equals(type)) {
                        value = valueText;
                    } else if ("java-object".equals(type)) {
                        try {
                            byte[] bytes = StringUtils.decodeBase64(valueText);
                            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
                            value = in.readObject();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (name != null && value != null) {
                        properties.put(name, (Integer)value);
                    }
                    done = true;
                }
            }
            if (eventType == 3 && parser.getName().equals("properties")) break;
        }
        return properties;
    }

    private static class ListenerWrapper {
        private PacketListener packetListener;
        private PacketCollector packetCollector;

        public ListenerWrapper(PacketReader packetReader, PacketListener packetListener, PacketFilter packetFilter) {
            this.packetListener = packetListener;
            this.packetCollector = new PacketCollector(packetReader, packetFilter);
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof ListenerWrapper) {
                return ((ListenerWrapper)object).packetListener.equals(this.packetListener);
            }
            if (object instanceof PacketListener) {
                return object.equals(this.packetListener);
            }
            return false;
        }

        public boolean notifyListener() {
            Packet packet = this.packetCollector.pollResult();
            if (packet != null) {
                this.packetListener.processPacket(packet);
                return true;
            }
            return false;
        }

        public void cancel() {
            this.packetCollector.cancel();
            this.packetCollector = null;
            this.packetListener = null;
        }
    }
}

