/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport.xstream;

import com.thoughtworks.xstream.XStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.jms.JMSException;
import org.codehaus.activemq.io.TextWireFormat;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.message.Packet;

public class XStreamWireFormat
extends TextWireFormat {
    private XStream xStream;

    public Packet readPacket(DataInput in) throws IOException {
        String text = in.readUTF();
        return (Packet)this.getXStream().fromXML(text);
    }

    public Packet readPacket(int firstByte, DataInput in) throws IOException {
        String text = in.readUTF();
        return (Packet)this.getXStream().fromXML(text);
    }

    public Packet writePacket(Packet packet, DataOutput out) throws IOException, JMSException {
        String text = this.getXStream().toXML((Object)packet);
        out.writeUTF(text);
        return null;
    }

    public WireFormat copy() {
        return new XStreamWireFormat();
    }

    public String toString(Packet packet) {
        return this.getXStream().toXML((Object)packet);
    }

    public Packet fromString(String xml) {
        return (Packet)this.getXStream().fromXML(xml);
    }

    public boolean canProcessWireFormatVersion(int version) {
        return true;
    }

    public int getCurrentWireFormatVersion() {
        return 1;
    }

    public XStream getXStream() {
        if (this.xStream == null) {
            this.xStream = this.createXStream();
        }
        return this.xStream;
    }

    public void setXStream(XStream xStream) {
        this.xStream = xStream;
    }

    protected XStream createXStream() {
        return new XStream();
    }
}

