/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport.http;

import java.net.URI;
import javax.jms.JMSException;
import org.codehaus.activemq.io.TextWireFormat;
import org.codehaus.activemq.transport.TransportServerChannelSupport;
import org.codehaus.activemq.transport.http.HttpTunnelServlet;
import org.codehaus.activemq.transport.xstream.XStreamWireFormat;
import org.codehaus.activemq.util.JMSExceptionHelper;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.SocketListener;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.ServletHandler;

public class HttpTransportConnector
extends TransportServerChannelSupport {
    private URI bindAddress;
    private TextWireFormat wireFormat;
    private Server server = new Server();
    private SocketListener listener = new SocketListener();

    public HttpTransportConnector(URI uri) {
        super(uri);
        this.bindAddress = uri;
    }

    public void start() throws JMSException {
        try {
            this.listener.setPort(this.bindAddress.getPort());
            this.server.addListener((HttpListener)this.listener);
            HttpContext context = this.server.addContext("/");
            ServletHandler handler = new ServletHandler();
            handler.addServlet("httpTunnel", "/*", HttpTunnelServlet.class.getName());
            context.addHandler((HttpHandler)handler);
            context.setAttribute("transportChannelListener", (Object)this.getTransportChannelListener());
            context.setAttribute("wireFormat", (Object)this.getWireFormat());
            this.server.start();
        }
        catch (Exception e) {
            throw JMSExceptionHelper.newJMSException((String)("Could not start HTTP server: " + e), (Exception)e);
        }
    }

    public synchronized void stop() throws JMSException {
        super.stop();
        try {
            this.server.stop();
        }
        catch (InterruptedException e) {
            throw JMSExceptionHelper.newJMSException((String)("Could not stop HTTP server: " + e), (Exception)e);
        }
    }

    public TextWireFormat getWireFormat() {
        if (this.wireFormat == null) {
            this.wireFormat = this.createWireFormat();
        }
        return this.wireFormat;
    }

    public void setWireFormat(TextWireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    protected TextWireFormat createWireFormat() {
        return new XStreamWireFormat();
    }
}

