/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport.http;

import javax.jms.JMSException;
import javax.servlet.ServletException;
import org.codehaus.activemq.broker.BrokerContainer;
import org.codehaus.activemq.broker.impl.BrokerContainerImpl;
import org.codehaus.activemq.transport.TransportChannelListener;
import org.codehaus.activemq.transport.TransportServerChannel;
import org.codehaus.activemq.transport.TransportServerChannelSupport;
import org.codehaus.activemq.transport.http.HttpTunnelServlet;

public class HttpEmbeddedTunnelServlet
extends HttpTunnelServlet {
    private BrokerContainer broker;
    private ServletConnector transportConnector;

    public synchronized void init() throws ServletException {
        if (this.broker == null) {
            this.broker = this.createBroker();
        }
        try {
            this.broker.start();
        }
        catch (JMSException e) {
            throw new ServletException("Failed to start embedded broker: " + (Object)((Object)e), (Throwable)e);
        }
        TransportChannelListener listener = this.transportConnector.getTransportChannelListener();
        this.getServletContext().setAttribute("transportChannelListener", (Object)listener);
        super.init();
    }

    protected BrokerContainer createBroker() {
        BrokerContainerImpl answer = new BrokerContainerImpl();
        String url = this.getConnectorURL();
        this.transportConnector = new ServletConnector(url);
        answer.addConnector((TransportServerChannel)this.transportConnector);
        String brokerURL = this.getServletContext().getInitParameter("org.codehaus.activemq.brokerURL");
        if (brokerURL != null) {
            this.log("Listening for internal communication on: " + brokerURL);
        }
        return answer;
    }

    protected String getConnectorURL() {
        return "http://localhost/" + this.getServletContext().getServletContextName();
    }

    protected static class ServletConnector
    extends TransportServerChannelSupport {
        public ServletConnector(String url) {
            super(url);
        }
    }
}

