/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport.http;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.io.TextWireFormat;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.transport.TransportChannel;
import org.codehaus.activemq.transport.TransportChannelFactorySupport;
import org.codehaus.activemq.transport.http.HttpTransportChannel;
import org.codehaus.activemq.transport.xstream.XStreamWireFormat;
import org.codehaus.activemq.util.JMSExceptionHelper;

public class HttpTransportChannelFactory
extends TransportChannelFactorySupport {
    private static final Log log = LogFactory.getLog((Class)HttpTransportChannelFactory.class);

    public TransportChannel create(WireFormat wireFormat, URI remoteLocation) throws JMSException {
        try {
            return this.create(wireFormat, remoteLocation, new URI("http://localhost:0"));
        }
        catch (URISyntaxException e) {
            throw JMSExceptionHelper.newJMSException((String)e.getMessage(), (Exception)e);
        }
    }

    public TransportChannel create(WireFormat wireFormat, URI remoteLocation, URI localLocation) throws JMSException {
        try {
            HttpTransportChannel channel = new HttpTransportChannel(this.asTextWireFormat(wireFormat), remoteLocation.toString());
            return this.populateProperties((TransportChannel)channel, remoteLocation);
        }
        catch (MalformedURLException e) {
            throw JMSExceptionHelper.newJMSException((String)e.getMessage(), (Exception)e);
        }
    }

    protected TextWireFormat asTextWireFormat(WireFormat wireFormat) {
        if (wireFormat instanceof TextWireFormat) {
            return (TextWireFormat)wireFormat;
        }
        log.trace((Object)("Not created with a TextWireFromat: " + wireFormat));
        return new XStreamWireFormat();
    }

    public boolean requiresEmbeddedBroker() {
        return false;
    }
}

