/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport.http;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import javax.jms.JMSException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.io.TextWireFormat;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.transport.http.HttpTransportChannelSupport;
import org.codehaus.activemq.util.JMSExceptionHelper;

public class HttpClientTransportChannel
extends HttpTransportChannelSupport {
    private static final Log log = LogFactory.getLog((Class)HttpClientTransportChannel.class);
    private HttpClient sendHttpClient;
    private HttpClient receiveHttpClient;

    public HttpClientTransportChannel(TextWireFormat wireFormat, String remoteUrl) {
        super(wireFormat, remoteUrl);
    }

    public void asyncSend(Packet packet) throws JMSException {
        PostMethod httpMethod = new PostMethod(this.getRemoteUrl());
        this.configureMethod((HttpMethod)httpMethod);
        httpMethod.setRequestBody(this.getWireFormat().toString(packet));
        try {
            int answer = this.getSendHttpClient().executeMethod((HttpMethod)httpMethod);
            if (answer != 200) {
                throw new JMSException("Failed to post packet: " + packet + " as response was: " + answer);
            }
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException((String)("Could not post packet: " + packet + " due to: " + e), (Exception)e);
        }
    }

    public boolean isMulticast() {
        return false;
    }

    public void run() {
        log.trace((Object)("HTTP GET consumer thread starting for clientID: " + this.getClientID()));
        HttpClient httpClient = this.getReceiveHttpClient();
        String remoteUrl = this.getRemoteUrl();
        while (!this.getClosed().get()) {
            GetMethod httpMethod = new GetMethod(remoteUrl);
            this.configureMethod((HttpMethod)httpMethod);
            try {
                int answer = httpClient.executeMethod((HttpMethod)httpMethod);
                if (answer != 200) {
                    if (answer == 408) {
                        log.info((Object)"GET timed out");
                        continue;
                    }
                    log.warn((Object)("Failed to perform GET on: " + remoteUrl + " as response was: " + answer));
                    continue;
                }
                Packet packet = this.getWireFormat().readPacket((DataInput)new DataInputStream(httpMethod.getResponseBodyAsStream()));
                if (packet == null) {
                    log.warn((Object)("Received null packet from url: " + remoteUrl));
                    continue;
                }
                this.doConsumePacket(packet);
            }
            catch (IOException e) {
                log.warn((Object)("Failed to perform GET on: " + remoteUrl + " due to: " + e), (Throwable)e);
            }
        }
    }

    public HttpClient getSendHttpClient() {
        if (this.sendHttpClient == null) {
            this.sendHttpClient = this.createHttpClient();
        }
        return this.sendHttpClient;
    }

    public void setSendHttpClient(HttpClient sendHttpClient) {
        this.sendHttpClient = sendHttpClient;
    }

    public HttpClient getReceiveHttpClient() {
        if (this.receiveHttpClient == null) {
            this.receiveHttpClient = this.createHttpClient();
        }
        return this.receiveHttpClient;
    }

    public void setReceiveHttpClient(HttpClient receiveHttpClient) {
        this.receiveHttpClient = receiveHttpClient;
    }

    protected HttpClient createHttpClient() {
        return new HttpClient();
    }

    protected void configureMethod(HttpMethod method) {
        String clientID = this.getClientID();
        if (clientID != null) {
            method.setRequestHeader("clientID", clientID);
        }
    }

    public void forceDisconnect() {
        throw new RuntimeException("Not yet Implemented.");
    }
}

