/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.store.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.MessageAck;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.service.MessageIdentity;
import org.codehaus.activemq.service.QueueMessageContainer;
import org.codehaus.activemq.store.MessageStore;
import org.codehaus.activemq.store.jdbc.JDBCAdapter;
import org.codehaus.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.codehaus.activemq.util.JMSExceptionHelper;
import org.codehaus.activemq.util.LongSequenceGenerator;

public class JDBCMessageStore
implements MessageStore {
    private static final Log log = LogFactory.getLog((Class)JDBCMessageStore.class);
    protected final WireFormat wireFormat;
    protected final String destinationName;
    protected final LongSequenceGenerator sequenceGenerator;
    protected final JDBCAdapter adapter;
    protected final JDBCPersistenceAdapter persistenceAdapter;

    public JDBCMessageStore(JDBCPersistenceAdapter persistenceAdapter, JDBCAdapter adapter, WireFormat wireFormat, String destinationName) {
        this.persistenceAdapter = persistenceAdapter;
        this.adapter = adapter;
        this.sequenceGenerator = adapter.getSequenceGenerator();
        this.wireFormat = wireFormat;
        this.destinationName = destinationName;
    }

    public MessageIdentity addMessage(ActiveMQMessage message) throws JMSException {
        byte[] data;
        String messageID = message.getJMSMessageID();
        try {
            data = this.wireFormat.toBytes((Packet)message);
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException((String)("Failed to broker message: " + messageID + " in container: " + e), (Exception)e);
        }
        long seq = this.sequenceGenerator.getNextSequenceId();
        Connection c = null;
        try {
            c = this.persistenceAdapter.getConnection();
            this.adapter.doAddMessage(c, seq, messageID, this.destinationName, data);
        }
        catch (SQLException e) {
            throw JMSExceptionHelper.newJMSException((String)("Failed to broker message: " + messageID + " in container: " + e), (Exception)e);
        }
        finally {
            this.persistenceAdapter.returnConnection(c);
        }
        MessageIdentity answer = message.getJMSMessageIdentity();
        answer.setSequenceNumber((Object)new Long(seq));
        return answer;
    }

    public ActiveMQMessage getMessage(MessageIdentity identity) throws JMSException {
        long id = this.getMessageSequenceId(identity);
        Connection c = null;
        try {
            c = this.persistenceAdapter.getConnection();
            byte[] data = this.adapter.doGetMessage(c, id);
            ActiveMQMessage answer = (ActiveMQMessage)this.wireFormat.fromBytes(data);
            answer.setJMSMessageIdentity(identity);
            ActiveMQMessage activeMQMessage = answer;
            return activeMQMessage;
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException((String)("Failed to broker message: " + identity.getMessageID() + " in container: " + e), (Exception)e);
        }
        catch (SQLException e) {
            throw JMSExceptionHelper.newJMSException((String)("Failed to broker message: " + identity.getMessageID() + " in container: " + e), (Exception)e);
        }
        finally {
            this.persistenceAdapter.returnConnection(c);
        }
    }

    private long getMessageSequenceId(MessageIdentity identity) throws JMSException {
        Object sequenceNumber = identity.getSequenceNumber();
        if (sequenceNumber != null && sequenceNumber.getClass() == Long.class) {
            return (Long)sequenceNumber;
        }
        Connection c = null;
        try {
            c = this.persistenceAdapter.getConnection();
            Long rc = this.adapter.getMessageSequenceId(c, identity.getMessageID());
            if (rc == null) {
                throw new JMSException("Could not locate message in database with message id: " + identity.getMessageID());
            }
            long l = rc;
            return l;
        }
        catch (SQLException e) {
            throw JMSExceptionHelper.newJMSException((String)("Failed to broker message: " + identity.getMessageID() + " in container: " + e), (Exception)e);
        }
        finally {
            this.persistenceAdapter.returnConnection(c);
        }
    }

    public void removeMessage(MessageIdentity identity, MessageAck ack) throws JMSException {
        long seq = this.getMessageSequenceId(identity);
        Connection c = null;
        try {
            c = this.persistenceAdapter.getConnection();
            this.adapter.doRemoveMessage(c, seq);
        }
        catch (SQLException e) {
            throw JMSExceptionHelper.newJMSException((String)("Failed to broker message: " + identity.getMessageID() + " in container: " + e), (Exception)e);
        }
        finally {
            this.persistenceAdapter.returnConnection(c);
        }
    }

    public void recover(final QueueMessageContainer container) throws JMSException {
        Connection c = null;
        try {
            c = this.persistenceAdapter.getConnection();
            this.adapter.doRecover(c, this.destinationName, new JDBCAdapter.MessageListResultHandler(){

                public void onMessage(long seq, String messageID) throws JMSException {
                    container.recoverMessageToBeDelivered(new MessageIdentity(messageID, (Object)new Long(seq)));
                }
            });
        }
        catch (SQLException e) {
            throw JMSExceptionHelper.newJMSException((String)("Failed to recover container. Reason: " + e), (Exception)e);
        }
        finally {
            this.persistenceAdapter.returnConnection(c);
        }
    }

    public void start() throws JMSException {
    }

    public void stop() throws JMSException {
    }

    public void removeAllMessages() throws JMSException {
        Connection c = null;
        try {
            c = this.persistenceAdapter.getConnection();
            this.adapter.doRemoveAllMessages(c, this.destinationName);
        }
        catch (SQLException e) {
            throw JMSExceptionHelper.newJMSException((String)("Failed to broker remove all messages: " + e), (Exception)e);
        }
        finally {
            this.persistenceAdapter.returnConnection(c);
        }
    }
}

