/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.store.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.ConsumerInfo;
import org.codehaus.activemq.message.MessageAck;
import org.codehaus.activemq.service.MessageContainer;
import org.codehaus.activemq.service.MessageIdentity;
import org.codehaus.activemq.service.SubscriberEntry;
import org.codehaus.activemq.service.Subscription;
import org.codehaus.activemq.store.TopicMessageStore;
import org.codehaus.activemq.store.jdbc.JDBCAdapter;
import org.codehaus.activemq.store.jdbc.JDBCMessageStore;
import org.codehaus.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.codehaus.activemq.util.JMSExceptionHelper;

public class JDBCTopicMessageStore
extends JDBCMessageStore
implements TopicMessageStore {
    private static final Log log = LogFactory.getLog((Class)JDBCTopicMessageStore.class);
    private MessageContainer container;

    public JDBCTopicMessageStore(JDBCPersistenceAdapter persistenceAdapter, JDBCAdapter adapter, WireFormat wireFormat, String destinationName) {
        super(persistenceAdapter, adapter, wireFormat, destinationName);
    }

    public void setLastAcknowledgedMessageIdentity(Subscription subscription, MessageIdentity messageIdentity) throws JMSException {
        long seq = (Long)messageIdentity.getSequenceNumber();
        Connection c = null;
        try {
            c = this.persistenceAdapter.getConnection();
            this.adapter.doSetLastAck(c, this.destinationName, subscription.getPersistentKey(), seq);
        }
        catch (SQLException e) {
            throw JMSExceptionHelper.newJMSException((String)("Failed to store ack for: " + subscription + " on message " + messageIdentity + " in container: " + e), (Exception)e);
        }
        finally {
            this.persistenceAdapter.returnConnection(c);
        }
    }

    public MessageIdentity getLastestMessageIdentity() throws JMSException {
        return new MessageIdentity(null, (Object)new Long(this.sequenceGenerator.getLastSequenceId()));
    }

    public void recoverSubscription(final Subscription subscription, MessageIdentity lastDispatchedMessage) throws JMSException {
        Connection c = null;
        try {
            c = this.persistenceAdapter.getConnection();
            this.adapter.doRecoverSubscription(c, subscription.getPersistentKey(), this.destinationName, new JDBCAdapter.MessageListResultHandler(){

                public void onMessage(long seq, String messageID) throws JMSException {
                    MessageIdentity messageIdentity = new MessageIdentity(messageID, (Object)new Long(seq));
                    ActiveMQMessage message = JDBCTopicMessageStore.this.getMessage(messageIdentity);
                    subscription.addMessage(JDBCTopicMessageStore.this.container, message);
                }
            });
        }
        catch (SQLException e) {
            throw JMSExceptionHelper.newJMSException((String)("Failed to recover subscription: " + subscription + ". Reason: " + e), (Exception)e);
        }
        finally {
            this.persistenceAdapter.returnConnection(c);
        }
    }

    public void setSubscriberEntry(ConsumerInfo info, SubscriberEntry subscriberEntry) throws JMSException {
        String key = info.getConsumerKey();
        Connection c = null;
        try {
            c = this.persistenceAdapter.getConnection();
            this.adapter.doSetSubscriberEntry(c, this.destinationName, key, subscriberEntry);
        }
        catch (SQLException e) {
            throw JMSExceptionHelper.newJMSException((String)("Failed to lookup subscription for info: " + info + ". Reason: " + e), (Exception)e);
        }
        finally {
            this.persistenceAdapter.returnConnection(c);
        }
    }

    public SubscriberEntry getSubscriberEntry(ConsumerInfo info) throws JMSException {
        String key = info.getConsumerKey();
        Connection c = null;
        try {
            c = this.persistenceAdapter.getConnection();
            SubscriberEntry subscriberEntry = this.adapter.doGetSubscriberEntry(c, this.destinationName, key);
            return subscriberEntry;
        }
        catch (SQLException e) {
            throw JMSExceptionHelper.newJMSException((String)("Failed to lookup subscription for info: " + info + ". Reason: " + e), (Exception)e);
        }
        finally {
            this.persistenceAdapter.returnConnection(c);
        }
    }

    public void setMessageContainer(MessageContainer container) {
        this.container = container;
    }

    public void incrementMessageCount(MessageIdentity messageId) throws JMSException {
    }

    public void decrementMessageCountAndMaybeDelete(MessageIdentity messageIdentity, MessageAck ack) throws JMSException {
    }
}

