/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.store.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.message.ActiveMQXid;
import org.codehaus.activemq.service.Transaction;
import org.codehaus.activemq.service.TransactionManager;
import org.codehaus.activemq.store.PreparedTransactionStore;
import org.codehaus.activemq.store.jdbc.JDBCAdapter;
import org.codehaus.activemq.store.jdbc.JDBCMessageStore;
import org.codehaus.activemq.store.jdbc.JDBCPersistenceAdapter;

public class JDBCPreparedTransactionStore
implements PreparedTransactionStore {
    private static final Log log = LogFactory.getLog((Class)JDBCMessageStore.class);
    private final WireFormat wireFormat;
    private final JDBCAdapter adapter;
    private final JDBCPersistenceAdapter persistenceAdapter;

    public JDBCPreparedTransactionStore(JDBCPersistenceAdapter persistenceAdapter, JDBCAdapter adapter, WireFormat wireFormat) {
        this.persistenceAdapter = persistenceAdapter;
        this.adapter = adapter;
        this.wireFormat = wireFormat;
    }

    public ActiveMQXid[] getXids() throws XAException {
        ArrayList list = new ArrayList();
        Connection c = null;
        try {
            c = this.persistenceAdapter.getConnection();
            this.adapter.doGetXids(c, list);
        }
        catch (SQLException e) {
            log.error((Object)("Failed to recover prepared transaction log: " + e), (Throwable)e);
            throw new XAException("Failed to recover container. Reason: " + e);
        }
        finally {
            this.persistenceAdapter.returnConnection(c);
        }
        ActiveMQXid[] answer = new ActiveMQXid[list.size()];
        list.toArray(answer);
        return answer;
    }

    public void remove(ActiveMQXid xid) throws XAException {
        Connection c = null;
        try {
            c = this.persistenceAdapter.getConnection();
            this.adapter.doRemoveXid(c, xid);
        }
        catch (SQLException e) {
            throw new XAException("Failed to remove prepared transaction: " + xid + ". Reason: " + e);
        }
        finally {
            this.persistenceAdapter.returnConnection(c);
        }
    }

    public void put(ActiveMQXid xid, Transaction transaction) throws XAException {
        byte[] data;
        String id = xid.toLocalTransactionId();
        try {
            data = xid.toBytes();
        }
        catch (Exception e) {
            throw new XAException("Failed to store prepared transaction: " + xid + ". Reason: " + e);
        }
        Connection c = null;
        try {
            c = this.persistenceAdapter.getConnection();
            this.adapter.doAddXid(c, xid, data);
        }
        catch (SQLException e) {
            throw new XAException("Failed to store prepared transaction: " + xid + ". Reason: " + e);
        }
        finally {
            this.persistenceAdapter.returnConnection(c);
        }
    }

    public void loadPreparedTransactions(TransactionManager transactionManager) throws XAException {
        Connection c = null;
        try {
            c = this.persistenceAdapter.getConnection();
            this.adapter.doLoadPreparedTransactions(c, transactionManager);
        }
        catch (SQLException e) {
            log.error((Object)("Failed to recover prepared transaction log: " + e), (Throwable)e);
            throw new XAException("Failed to recover prepared transaction log. Reason: " + e);
        }
        finally {
            this.persistenceAdapter.returnConnection(c);
        }
    }

    public void start() throws JMSException {
    }

    public synchronized void stop() throws JMSException {
    }
}

