/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.gbean.management;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.activemq.gbean.ActiveMQBroker;
import org.activemq.gbean.ActiveMQConnector;
import org.activemq.gbean.ActiveMQConnectorGBean;
import org.activemq.gbean.ActiveMQManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.EditableConfigurationManager;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.proxy.ProxyManager;
import org.apache.geronimo.management.geronimo.JMSBroker;
import org.apache.geronimo.management.geronimo.JMSConnector;
import org.apache.geronimo.management.geronimo.NetworkConnector;

public class ActiveMQManagerGBean
implements ActiveMQManager {
    private static final Log log = LogFactory.getLog((String)ActiveMQManagerGBean.class.getName());
    private Kernel kernel;
    private String objectName;
    public static final GBeanInfo GBEAN_INFO;

    public ActiveMQManagerGBean(Kernel kernel, String objectName) {
        this.kernel = kernel;
        this.objectName = objectName;
    }

    public String getProductName() {
        return "ActiveMQ";
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isEventProvider() {
        return false;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public Object[] getContainers() {
        ProxyManager proxyManager = this.kernel.getProxyManager();
        AbstractNameQuery query = new AbstractNameQuery(ActiveMQBroker.class.getName());
        Set names = this.kernel.listGBeans(query);
        Object[] results = new ActiveMQBroker[names.size()];
        int i = 0;
        Iterator it = names.iterator();
        while (it.hasNext()) {
            AbstractName name = (AbstractName)it.next();
            results[i] = (ActiveMQBroker)proxyManager.createProxy(name, (class$org$activemq$gbean$ActiveMQBroker == null ? ActiveMQManagerGBean.class$("org.activemq.gbean.ActiveMQBroker") : class$org$activemq$gbean$ActiveMQBroker).getClassLoader());
            ++i;
        }
        return results;
    }

    public String[] getSupportedProtocols() {
        return new String[]{"activeio", "jabber", "multicast", "openwire", "peer", "stomp", "tcp", "udp", "vm"};
    }

    public NetworkConnector[] getConnectors() {
        ProxyManager proxyManager = this.kernel.getProxyManager();
        AbstractNameQuery query = new AbstractNameQuery(ActiveMQConnector.class.getName());
        Set names = this.kernel.listGBeans(query);
        ActiveMQConnector[] results = new ActiveMQConnector[names.size()];
        int i = 0;
        Iterator it = names.iterator();
        while (it.hasNext()) {
            AbstractName name = (AbstractName)it.next();
            results[i] = (ActiveMQConnector)proxyManager.createProxy(name, (class$org$activemq$gbean$ActiveMQConnector == null ? ActiveMQManagerGBean.class$("org.activemq.gbean.ActiveMQConnector") : class$org$activemq$gbean$ActiveMQConnector).getClassLoader());
            ++i;
        }
        return results;
    }

    public NetworkConnector[] getConnectors(String protocol) {
        if (protocol == null) {
            return this.getConnectors();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        ProxyManager proxyManager = this.kernel.getProxyManager();
        AbstractNameQuery query = new AbstractNameQuery(ActiveMQConnector.class.getName());
        Set names = this.kernel.listGBeans(query);
        Iterator it = names.iterator();
        while (it.hasNext()) {
            AbstractName name = (AbstractName)it.next();
            try {
                if (!this.kernel.getAttribute(name, "protocol").equals(protocol)) continue;
                result.add(proxyManager.createProxy(name, (class$org$activemq$gbean$ActiveMQConnector == null ? ActiveMQManagerGBean.class$("org.activemq.gbean.ActiveMQConnector") : class$org$activemq$gbean$ActiveMQConnector).getClassLoader()));
            }
            catch (Exception e) {
                log.error((Object)"Unable to check the protocol for a connector", (Throwable)e);
            }
        }
        return result.toArray(new ActiveMQConnector[names.size()]);
    }

    public NetworkConnector[] getConnectorsForContainer(Object broker) {
        AbstractName containerName = this.kernel.getAbstractNameFor(broker);
        ProxyManager mgr = this.kernel.getProxyManager();
        try {
            ArrayList<Object> results = new ArrayList<Object>();
            AbstractNameQuery query = new AbstractNameQuery(ActiveMQConnector.class.getName());
            Set set = this.kernel.listGBeans(query);
            Iterator it = set.iterator();
            while (it.hasNext()) {
                AbstractName name = (AbstractName)it.next();
                GBeanData data = this.kernel.getGBeanData(name);
                ReferencePatterns refs = data.getReferencePatterns("activeMQContainer");
                if (!containerName.equals((Object)refs.getAbstractName())) continue;
                results.add(mgr.createProxy(name, (class$org$activemq$gbean$ActiveMQConnector == null ? ActiveMQManagerGBean.class$("org.activemq.gbean.ActiveMQConnector") : class$org$activemq$gbean$ActiveMQConnector).getClassLoader()));
            }
            return results.toArray(new ActiveMQConnector[results.size()]);
        }
        catch (Exception e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Unable to look up connectors for ActiveMQ broker '" + containerName).initCause(e);
        }
    }

    public NetworkConnector[] getConnectorsForContainer(Object broker, String protocol) {
        if (protocol == null) {
            return this.getConnectorsForContainer(broker);
        }
        AbstractName containerName = this.kernel.getAbstractNameFor(broker);
        ProxyManager mgr = this.kernel.getProxyManager();
        try {
            ArrayList<Object> results = new ArrayList<Object>();
            AbstractNameQuery query = new AbstractNameQuery(ActiveMQConnector.class.getName());
            Set set = this.kernel.listGBeans(query);
            Iterator it = set.iterator();
            while (it.hasNext()) {
                AbstractName name = (AbstractName)it.next();
                GBeanData data = this.kernel.getGBeanData(name);
                ReferencePatterns refs = data.getReferencePatterns("activeMQContainer");
                if (!containerName.equals((Object)refs.getAbstractName())) continue;
                try {
                    String testProtocol = (String)this.kernel.getAttribute(name, "protocol");
                    if (testProtocol == null || !testProtocol.equals(protocol)) break;
                    results.add(mgr.createProxy(name, ActiveMQConnector.class.getClassLoader()));
                }
                catch (Exception e) {
                    log.error((Object)("Unable to look up protocol for connector '" + name + "'"), (Throwable)e);
                }
                break;
            }
            return results.toArray(new ActiveMQConnector[results.size()]);
        }
        catch (Exception e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Unable to look up connectors for ActiveMQ broker '" + containerName + "': ").initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMSConnector addConnector(JMSBroker broker, String uniqueName, String protocol, String host, int port) {
        AbstractName brokerAbstractName = this.kernel.getAbstractNameFor((Object)broker);
        AbstractName name = this.kernel.getNaming().createChildName(brokerAbstractName, uniqueName, "GBean");
        GBeanData connector = new GBeanData(name, ActiveMQConnectorGBean.GBEAN_INFO);
        connector.setAttribute("protocol", (Object)protocol);
        connector.setAttribute("host", (Object)host);
        connector.setAttribute("port", (Object)new Integer(port));
        connector.setReferencePattern("activeMQContainer", brokerAbstractName);
        EditableConfigurationManager mgr = ConfigurationUtil.getEditableConfigurationManager((Kernel)this.kernel);
        if (mgr != null) {
            try {
                mgr.addGBeanToConfiguration(brokerAbstractName.getArtifact(), connector, false);
                JMSConnector jMSConnector = (JMSConnector)this.kernel.getProxyManager().createProxy(name, ActiveMQConnector.class.getClassLoader());
                return jMSConnector;
            }
            catch (InvalidConfigException e) {
                log.error((Object)"Unable to add GBean", (Throwable)e);
                JMSConnector jMSConnector = null;
                return jMSConnector;
            }
            finally {
                ConfigurationUtil.releaseConfigurationManager((Kernel)this.kernel, (ConfigurationManager)mgr);
            }
        }
        log.warn((Object)"The ConfigurationManager in the kernel does not allow editing");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnector(AbstractName connectorName) {
        block11: {
            try {
                GBeanInfo info = this.kernel.getGBeanInfo(connectorName);
                boolean found = false;
                Set intfs = info.getInterfaces();
                Iterator it = intfs.iterator();
                while (it.hasNext()) {
                    String intf = (String)it.next();
                    if (!intf.equals((class$org$activemq$gbean$ActiveMQConnector == null ? ActiveMQManagerGBean.class$("org.activemq.gbean.ActiveMQConnector") : class$org$activemq$gbean$ActiveMQConnector).getName())) continue;
                    found = true;
                }
                if (!found) {
                    throw new GBeanNotFoundException(connectorName);
                }
                EditableConfigurationManager mgr = ConfigurationUtil.getEditableConfigurationManager((Kernel)this.kernel);
                if (mgr != null) {
                    try {
                        mgr.removeGBeanFromConfiguration(connectorName.getArtifact(), connectorName);
                        break block11;
                    }
                    catch (InvalidConfigException e) {
                        log.error((Object)"Unable to add GBean", (Throwable)e);
                        break block11;
                    }
                    finally {
                        ConfigurationUtil.releaseConfigurationManager((Kernel)this.kernel, (ConfigurationManager)mgr);
                    }
                }
                log.warn((Object)"The ConfigurationManager in the kernel does not allow editing");
            }
            catch (GBeanNotFoundException e) {
                log.warn((Object)("No such GBean '" + connectorName + "'"));
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder("ActiveMQ Manager", ActiveMQManagerGBean.class);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("objectName", String.class, false);
        infoFactory.addInterface(ActiveMQManager.class);
        infoFactory.setConstructor(new String[]{"kernel", "objectName"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

