/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.gbean;

import java.util.Properties;
import javax.jms.JMSException;
import org.activemq.broker.BrokerAdmin;
import org.activemq.broker.BrokerContainer;
import org.activemq.broker.BrokerContext;
import org.activemq.broker.impl.BrokerContainerImpl;
import org.activemq.gbean.ActiveMQContainer;
import org.activemq.security.SecurityAdapter;
import org.activemq.security.jassjacc.JassJaccSecurityAdapter;
import org.activemq.security.jassjacc.PropertiesConfigLoader;
import org.activemq.store.PersistenceAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.management.geronimo.JMSManager;
import org.apache.geronimo.management.geronimo.NetworkConnector;

public class ActiveMQContainerGBean
implements GBeanLifecycle,
ActiveMQContainer {
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    private final String brokerName;
    private final String objectName;
    private BrokerContext context = BrokerContext.getInstance();
    private BrokerContainer container;
    private final PersistenceAdapter persistenceAdapter;
    private final String jaasConfiguration;
    private final Properties securityRoles;
    private final JMSManager manager;
    public static final GBeanInfo GBEAN_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ActiveMQContainerGBean() {
        this.brokerName = null;
        this.jaasConfiguration = null;
        this.securityRoles = null;
        this.persistenceAdapter = null;
        this.objectName = null;
        this.manager = null;
    }

    public ActiveMQContainerGBean(String brokerName, PersistenceAdapter persistenceAdapter, String jaasConfiguration, Properties securityRoles, String objectName, JMSManager manager) {
        if (!$assertionsDisabled && brokerName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && persistenceAdapter == null) {
            throw new AssertionError();
        }
        this.brokerName = brokerName;
        this.jaasConfiguration = jaasConfiguration;
        this.persistenceAdapter = persistenceAdapter;
        this.securityRoles = securityRoles;
        this.objectName = objectName;
        this.manager = manager;
    }

    public synchronized BrokerContainer getBrokerContainer() {
        return this.container;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return true;
    }

    public NetworkConnector[] getConnectors() {
        return this.manager.getConnectorsForContainer((Object)this);
    }

    public NetworkConnector[] getConnectors(String protocol) {
        return this.manager.getConnectorsForContainer((Object)this, protocol);
    }

    public BrokerAdmin getBrokerAdmin() {
        return this.container.getBroker().getBrokerAdmin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doStart() throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ActiveMQContainerGBean.class.getClassLoader());
        try {
            if (this.container == null) {
                this.container = this.createContainer();
                this.container.start();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public synchronized void doStop() throws Exception {
        if (this.container != null) {
            BrokerContainer temp = this.container;
            this.container = null;
            temp.stop();
        }
    }

    public synchronized void doFail() {
        if (this.container != null) {
            BrokerContainer temp = this.container;
            this.container = null;
            try {
                temp.stop();
            }
            catch (JMSException e) {
                this.log.info((Object)("Caught while closing due to failure: " + (Object)((Object)e)), (Throwable)e);
            }
        }
    }

    protected BrokerContainer createContainer() throws Exception {
        BrokerContainerImpl answer = new BrokerContainerImpl(this.brokerName, this.context);
        answer.setPersistenceAdapter(this.persistenceAdapter);
        if (this.jaasConfiguration != null) {
            answer.setSecurityAdapter((SecurityAdapter)new JassJaccSecurityAdapter(this.jaasConfiguration));
        }
        if (this.securityRoles != null) {
            PropertiesConfigLoader loader = new PropertiesConfigLoader(this.brokerName, this.securityRoles);
            loader.installSecurity();
        }
        return answer;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public String getJaasConfiguration() {
        return this.jaasConfiguration;
    }

    public Properties getSecurityRoles() {
        return this.securityRoles;
    }

    static {
        $assertionsDisabled = !ActiveMQContainerGBean.class.desiredAssertionStatus();
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder("ActiveMQ Message Broker", ActiveMQContainerGBean.class, "JMSServer");
        infoFactory.addAttribute("brokerName", String.class, true);
        infoFactory.addReference("persistenceAdapter", PersistenceAdapter.class);
        infoFactory.addReference("JMSManager", JMSManager.class);
        infoFactory.addAttribute("jaasConfiguration", String.class, true);
        infoFactory.addAttribute("securityRoles", Properties.class, true);
        infoFactory.addAttribute("objectName", String.class, false);
        infoFactory.addInterface(ActiveMQContainer.class);
        infoFactory.setConstructor(new String[]{"brokerName", "persistenceAdapter", "jaasConfiguration", "securityRoles", "objectName", "JMSManager"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

