/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.gbean.management;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.activemq.gbean.ActiveMQBroker;
import org.activemq.gbean.ActiveMQConnector;
import org.activemq.gbean.ActiveMQConnectorGBean;
import org.activemq.gbean.ActiveMQManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanQuery;
import org.apache.geronimo.j2ee.management.impl.Util;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;

public class ActiveMQManagerGBean
implements ActiveMQManager {
    private static final Log log = LogFactory.getLog((String)ActiveMQManagerGBean.class.getName());
    private Kernel kernel;
    public static final GBeanInfo GBEAN_INFO;

    public ActiveMQManagerGBean(Kernel kernel) {
        this.kernel = kernel;
    }

    public String getProductName() {
        return "ActiveMQ";
    }

    public String[] getContainers() {
        GBeanQuery query = new GBeanQuery(null, ActiveMQBroker.class.getName());
        Set set = this.kernel.listGBeans(query);
        String[] results = new String[set.size()];
        int i = 0;
        Iterator it = set.iterator();
        while (it.hasNext()) {
            ObjectName name = (ObjectName)it.next();
            results[i++] = name.getCanonicalName();
        }
        return results;
    }

    public String[] getSupportedProtocols() {
        return new String[]{"activeio", "jabber", "multicast", "openwire", "peer", "stomp", "tcp", "udp", "vm"};
    }

    public String[] getConnectors() {
        GBeanQuery query = new GBeanQuery(null, ActiveMQConnector.class.getName());
        Set set = this.kernel.listGBeans(query);
        String[] results = new String[set.size()];
        int i = 0;
        Iterator it = set.iterator();
        while (it.hasNext()) {
            ObjectName name = (ObjectName)it.next();
            results[i++] = name.getCanonicalName();
        }
        return results;
    }

    public String[] getConnectors(String protocol) {
        if (protocol == null) {
            return this.getConnectors();
        }
        GBeanQuery query = new GBeanQuery(null, ActiveMQConnector.class.getName());
        Set set = this.kernel.listGBeans(query);
        ArrayList<String> results = new ArrayList<String>();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            ObjectName name = (ObjectName)it.next();
            try {
                String target = (String)this.kernel.getAttribute(name, "protocol");
                if (target == null || !target.equals(protocol)) continue;
                results.add(name.getCanonicalName());
            }
            catch (Exception e) {
                log.error((Object)("Unable to look up protocol for connector '" + name + "'"), (Throwable)e);
            }
        }
        return results.toArray(new String[results.size()]);
    }

    public String[] getConnectorsForContainer(String broker) {
        try {
            ObjectName brokerName = ObjectName.getInstance(broker);
            ArrayList<String> results = new ArrayList<String>();
            GBeanQuery query = new GBeanQuery(null, ActiveMQConnector.class.getName());
            Set set = this.kernel.listGBeans(query);
            Iterator it = set.iterator();
            block2: while (it.hasNext()) {
                ObjectName name = (ObjectName)it.next();
                GBeanData data = this.kernel.getGBeanData(name);
                Set refs = data.getReferencePatterns("activeMQContainer");
                Iterator refit = refs.iterator();
                while (refit.hasNext()) {
                    ObjectName ref = (ObjectName)refit.next();
                    if (ref.isPattern()) {
                        Set matches = this.kernel.listGBeans(ref);
                        if (matches.size() != 1) {
                            log.error((Object)("Unable to compare a connector->container reference that's a pattern to a fixed container name: " + ref.getCanonicalName()));
                            continue;
                        }
                        ref = (ObjectName)matches.iterator().next();
                        if (!ref.equals(brokerName)) continue;
                        results.add(name.getCanonicalName());
                        continue block2;
                    }
                    if (!ref.equals(brokerName)) continue;
                    results.add(name.getCanonicalName());
                    continue block2;
                }
            }
            return results.toArray(new String[results.size()]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to look up connectors for broker '" + broker + "': " + e);
        }
    }

    public String[] getConnectorsForContainer(String broker, String protocol) {
        if (protocol == null) {
            return this.getConnectorsForContainer(broker);
        }
        try {
            ObjectName brokerName = ObjectName.getInstance(broker);
            ArrayList<String> results = new ArrayList<String>();
            GBeanQuery query = new GBeanQuery(null, ActiveMQConnector.class.getName());
            Set set = this.kernel.listGBeans(query);
            Iterator it = set.iterator();
            block4: while (it.hasNext()) {
                ObjectName name = (ObjectName)it.next();
                GBeanData data = this.kernel.getGBeanData(name);
                Set refs = data.getReferencePatterns("activeMQContainer");
                Iterator refit = refs.iterator();
                while (refit.hasNext()) {
                    ObjectName ref = (ObjectName)refit.next();
                    boolean match = false;
                    if (ref.isPattern()) {
                        Set matches = this.kernel.listGBeans(ref);
                        if (matches.size() != 1) {
                            log.error((Object)("Unable to compare a connector->container reference that's a pattern to a fixed container name: " + ref.getCanonicalName()));
                        } else {
                            ref = (ObjectName)matches.iterator().next();
                            if (ref.equals(brokerName)) {
                                match = true;
                            }
                        }
                    } else if (ref.equals(brokerName)) {
                        match = true;
                    }
                    if (!match) continue;
                    try {
                        String testProtocol = (String)this.kernel.getAttribute(name, "protocol");
                        if (testProtocol == null || !testProtocol.equals(protocol)) continue block4;
                        results.add(name.getCanonicalName());
                    }
                    catch (Exception e) {
                        log.error((Object)("Unable to look up protocol for connector '" + name + "'"), (Throwable)e);
                    }
                    continue block4;
                }
            }
            return results.toArray(new String[results.size()]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to look up connectors for broker '" + broker + "': " + e);
        }
    }

    public String addConnector(String broker, String uniqueName, String protocol, String host, int port) {
        ObjectName brokerName = null;
        try {
            brokerName = ObjectName.getInstance(broker);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Unable to parse ObjectName '" + broker + "'");
        }
        ObjectName name = this.getConnectorName(brokerName, protocol, host, port, uniqueName);
        GBeanData connector = new GBeanData(name, ActiveMQConnectorGBean.GBEAN_INFO);
        connector.setAttribute("protocol", (Object)protocol);
        connector.setAttribute("host", (Object)host);
        connector.setAttribute("port", (Object)new Integer(port));
        connector.setReferencePattern("activeMQContainer", brokerName);
        ObjectName config = Util.getConfiguration((Kernel)this.kernel, (ObjectName)brokerName);
        try {
            this.kernel.invoke(config, "addGBean", new Object[]{connector, Boolean.FALSE}, new String[]{GBeanData.class.getName(), Boolean.TYPE.getName()});
        }
        catch (Exception e) {
            log.error((Object)"Unable to add GBean ", (Throwable)e);
            return null;
        }
        return name.getCanonicalName();
    }

    public void removeConnector(String objectName) {
        ObjectName name = null;
        try {
            name = ObjectName.getInstance(objectName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid object name '" + objectName + "': " + e.getMessage());
        }
        try {
            GBeanInfo info = this.kernel.getGBeanInfo(name);
            boolean found = false;
            Set intfs = info.getInterfaces();
            Iterator it = intfs.iterator();
            while (it.hasNext()) {
                String intf = (String)it.next();
                if (!intf.equals((class$org$activemq$gbean$ActiveMQConnector == null ? ActiveMQManagerGBean.class$("org.activemq.gbean.ActiveMQConnector") : class$org$activemq$gbean$ActiveMQConnector).getName())) continue;
                found = true;
            }
            if (!found) {
                throw new GBeanNotFoundException(name);
            }
            ObjectName config = Util.getConfiguration((Kernel)this.kernel, (ObjectName)name);
            this.kernel.invoke(config, "removeGBean", new Object[]{name}, new String[]{ObjectName.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            log.warn((Object)("No such GBean '" + objectName + "'"));
        }
        catch (Exception e) {
            log.error((Object)"Unable to remove GBean", (Throwable)e);
        }
    }

    private ObjectName getConnectorName(ObjectName broker, String protocol, String host, int port, String uniqueName) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("J2EEApplication", broker.getKeyProperty("J2EEApplication"));
        table.put("J2EEServer", broker.getKeyProperty("J2EEServer"));
        table.put("J2EEModule", broker.getKeyProperty("J2EEModule"));
        table.put("j2eeType", "JMSConnector");
        String brokerName = broker.getKeyProperty("name");
        table.put("broker", brokerName);
        table.put("name", brokerName + "." + protocol + "." + host + (port > -1 ? "." + port : "") + "-" + uniqueName);
        try {
            return ObjectName.getInstance(broker.getDomain(), table);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Never should have failed: " + e.getMessage());
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder("ActiveMQ Manager", ActiveMQManagerGBean.class);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addInterface(ActiveMQManager.class);
        infoFactory.setConstructor(new String[]{"kernel"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

