/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.journal;

import java.util.Map;
import javax.jms.JMSException;
import org.activemq.store.MessageStore;
import org.activemq.store.PersistenceAdapter;
import org.activemq.store.TopicMessageStore;
import org.activemq.store.TransactionStore;
import org.activemq.store.journal.JournalPersistenceAdapter;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class JournalPersistenceAdapterGBean
implements GBeanLifecycle,
PersistenceAdapter {
    private final PersistenceAdapter longTermPersistence;
    private final ServerInfo serverInfo;
    private final String directory;
    private JournalPersistenceAdapter persistenceAdapter;
    private final String journalType;
    public static final GBeanInfo GBEAN_INFO;

    public JournalPersistenceAdapterGBean() {
        this(null, null, null, null);
    }

    public JournalPersistenceAdapterGBean(ServerInfo serverInfo, PersistenceAdapter longTermPersistence, String directory, String journalType) {
        this.serverInfo = serverInfo;
        this.longTermPersistence = longTermPersistence;
        this.directory = directory;
        this.journalType = journalType;
    }

    public void doStart() throws Exception {
        this.persistenceAdapter = new JournalPersistenceAdapter();
        this.persistenceAdapter.setLongTermPersistence(this.longTermPersistence);
        this.persistenceAdapter.setDirectory(this.serverInfo.resolve(this.directory));
        this.persistenceAdapter.setJournalType(this.journalType);
        this.persistenceAdapter.start();
    }

    public void doStop() throws Exception {
        this.persistenceAdapter.stop();
        this.persistenceAdapter = null;
    }

    public void doFail() {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    public void beginTransaction() throws JMSException {
        this.persistenceAdapter.beginTransaction();
    }

    public void commitTransaction() throws JMSException {
        this.persistenceAdapter.commitTransaction();
    }

    public MessageStore createQueueMessageStore(String destinationName) throws JMSException {
        return this.persistenceAdapter.createQueueMessageStore(destinationName);
    }

    public TopicMessageStore createTopicMessageStore(String destinationName) throws JMSException {
        return this.persistenceAdapter.createTopicMessageStore(destinationName);
    }

    public TransactionStore createTransactionStore() throws JMSException {
        return this.persistenceAdapter.createTransactionStore();
    }

    public Map getInitialDestinations() {
        return this.persistenceAdapter.getInitialDestinations();
    }

    public void rollbackTransaction() {
        this.persistenceAdapter.rollbackTransaction();
    }

    public void start() throws JMSException {
    }

    public void stop() throws JMSException {
    }

    public boolean deadLetterAlreadySent(long seq, boolean useDatabaseLocking) {
        return this.persistenceAdapter.deadLetterAlreadySent(seq, useDatabaseLocking);
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder("ActiveMQ Persistence Journal", JournalPersistenceAdapterGBean.class, "JMSPersistence");
        infoFactory.addReference("serverInfo", ServerInfo.class);
        infoFactory.addReference("longTermPersistence", PersistenceAdapter.class);
        infoFactory.addAttribute("directory", String.class, true);
        infoFactory.addAttribute("journalType", String.class, true);
        infoFactory.addInterface(PersistenceAdapter.class);
        infoFactory.setConstructor(new String[]{"serverInfo", "longTermPersistence", "directory", "journalType"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

