/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.store.jdbm;

import java.util.Map;
import javax.jms.JMSException;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.WaitingException;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.codehaus.activemq.service.QueueMessageContainer;
import org.codehaus.activemq.service.TopicMessageContainer;
import org.codehaus.activemq.store.MessageStore;
import org.codehaus.activemq.store.PersistenceAdapter;
import org.codehaus.activemq.store.TopicMessageStore;
import org.codehaus.activemq.store.TransactionStore;
import org.codehaus.activemq.store.jdbm.JdbmPersistenceAdapter;

public class JdbmPersistenceAdapterGBean
implements GBeanLifecycle,
PersistenceAdapter {
    private JdbmPersistenceAdapter pa;
    private String directory;
    private final ServerInfo serverInfo;
    public static final GBeanInfo GBEAN_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JdbmPersistenceAdapterGBean() {
        this.serverInfo = null;
    }

    public JdbmPersistenceAdapterGBean(ServerInfo serverInfo, String directory) {
        if (!$assertionsDisabled && serverInfo == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && directory == null) {
            throw new AssertionError();
        }
        this.serverInfo = serverInfo;
        this.directory = directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void doStart() throws WaitingException, Exception {
        this.pa = new JdbmPersistenceAdapter(this.serverInfo.resolve(this.directory));
        this.pa.start();
    }

    public void doStop() throws WaitingException, Exception {
        this.pa.stop();
        this.pa = null;
    }

    public void doFail() {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    public void beginTransaction() throws JMSException {
        this.pa.beginTransaction();
    }

    public void commitTransaction() throws JMSException {
        this.pa.commitTransaction();
    }

    public QueueMessageContainer createQueueMessageContainer(String destinationName) throws JMSException {
        return this.pa.createQueueMessageContainer(destinationName);
    }

    public MessageStore createQueueMessageStore(String destinationName) throws JMSException {
        return this.pa.createQueueMessageStore(destinationName);
    }

    public TopicMessageContainer createTopicMessageContainer(String destinationName) throws JMSException {
        return this.pa.createTopicMessageContainer(destinationName);
    }

    public TopicMessageStore createTopicMessageStore(String destinationName) throws JMSException {
        return this.pa.createTopicMessageStore(destinationName);
    }

    public TransactionStore createTransactionStore() throws JMSException {
        return this.pa.createTransactionStore();
    }

    public Map getInitialDestinations() {
        return this.pa.getInitialDestinations();
    }

    public void rollbackTransaction() {
        this.pa.rollbackTransaction();
    }

    public void start() throws JMSException {
    }

    public void stop() throws JMSException {
    }

    static {
        $assertionsDisabled = !JdbmPersistenceAdapterGBean.class.desiredAssertionStatus();
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder("ActiveMQ JDBM Persistence", JdbmPersistenceAdapterGBean.class, "JMSPersistence");
        infoFactory.addReference("ServerInfo", ServerInfo.class);
        infoFactory.addAttribute("dataDirectory", String.class, true);
        infoFactory.addInterface(PersistenceAdapter.class);
        infoFactory.setConstructor(new String[]{"ServerInfo", "dataDirectory"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

