/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.gbean;

import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.GConstructorInfo;
import org.apache.geronimo.gbean.WaitingException;
import org.codehaus.activemq.ActiveMQConnectionFactory;
import org.codehaus.activemq.broker.BrokerConnector;
import org.codehaus.activemq.broker.impl.BrokerConnectorImpl;
import org.codehaus.activemq.gbean.ActiveMQContainer;
import org.codehaus.activemq.gbean.ActiveMQContainerGBean;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.io.impl.DefaultWireFormat;

public class ActiveMQConnectorGBean
implements GBeanLifecycle {
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    private BrokerConnector brokerConnector;
    private ActiveMQContainer container;
    private WireFormat wireFormat = new DefaultWireFormat();
    private String url = "tcp://localhost:61616";
    public static final GBeanInfo GBEAN_INFO;

    public ActiveMQConnectorGBean(ActiveMQContainer container) {
        this.container = container;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public WireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void setWireFormat(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doStart() throws WaitingException, Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ActiveMQContainerGBean.class.getClassLoader());
        try {
            if (this.brokerConnector == null) {
                this.brokerConnector = this.createBrokerConnector();
                this.brokerConnector.start();
                ActiveMQConnectionFactory.registerBroker((String)this.url, (BrokerConnector)this.brokerConnector);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public synchronized void doStop() throws WaitingException, Exception {
        if (this.brokerConnector != null) {
            ActiveMQConnectionFactory.unregisterBroker((String)this.url);
            BrokerConnector temp = this.brokerConnector;
            this.brokerConnector = null;
            temp.stop();
        }
    }

    public synchronized void doFail() {
        if (this.brokerConnector != null) {
            BrokerConnector temp = this.brokerConnector;
            this.brokerConnector = null;
            try {
                temp.stop();
            }
            catch (JMSException e) {
                this.log.info((Object)("Caught while closing due to failure: " + (Object)((Object)e)), (Throwable)e);
            }
        }
    }

    protected BrokerConnector createBrokerConnector() throws Exception {
        return new BrokerConnectorImpl(this.container.getBrokerContainer(), this.url, this.wireFormat);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder("ActiveMQ Message Broker Connector", ActiveMQConnectorGBean.class, "JMSConnector");
        infoFactory.addAttribute("url", String.class.getName(), true);
        infoFactory.addAttribute("wireFormat", WireFormat.class.getName(), false);
        infoFactory.addReference("ActiveMQContainer", ActiveMQContainer.class);
        infoFactory.setConstructor(new GConstructorInfo(new String[]{"ActiveMQContainer"}));
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

