/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.gbean;

import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.WaitingException;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.codehaus.activemq.broker.BrokerContainer;
import org.codehaus.activemq.broker.BrokerContext;
import org.codehaus.activemq.broker.impl.BrokerContainerImpl;
import org.codehaus.activemq.gbean.ActiveMQContainer;
import org.codehaus.activemq.store.PersistenceAdapter;
import org.codehaus.activemq.store.jdbm.JdbmPersistenceAdapter;

public class ActiveMQContainerGBean
implements GBeanLifecycle,
ActiveMQContainer {
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    private final String brokerName;
    private BrokerContext context = BrokerContext.getInstance();
    private BrokerContainer container;
    private final ServerInfo serverInfo;
    private final String dataDirectory;
    public static final GBeanInfo GBEAN_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ActiveMQContainerGBean() {
        this.serverInfo = null;
        this.brokerName = null;
        this.dataDirectory = "/var/activemq";
    }

    public ActiveMQContainerGBean(ServerInfo serverInfo, String brokerName, String dataDirectory) {
        if (!$assertionsDisabled && serverInfo == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && brokerName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dataDirectory == null) {
            throw new AssertionError();
        }
        this.serverInfo = serverInfo;
        this.brokerName = brokerName;
        this.dataDirectory = dataDirectory;
    }

    public synchronized BrokerContainer getBrokerContainer() {
        return this.container;
    }

    public synchronized void doStart() throws WaitingException, Exception {
        if (this.container == null) {
            this.container = this.createContainer();
            this.container.start();
        }
    }

    public synchronized void doStop() throws WaitingException, Exception {
        if (this.container != null) {
            BrokerContainer temp = this.container;
            this.container = null;
            temp.stop();
        }
    }

    public synchronized void doFail() {
        if (this.container != null) {
            BrokerContainer temp = this.container;
            this.container = null;
            try {
                temp.stop();
            }
            catch (JMSException e) {
                this.log.info((Object)("Caught while closing due to failure: " + (Object)((Object)e)), (Throwable)e);
            }
        }
    }

    protected BrokerContainer createContainer() throws Exception {
        BrokerContainerImpl answer = new BrokerContainerImpl(this.brokerName, this.context);
        JdbmPersistenceAdapter pa = new JdbmPersistenceAdapter(this.serverInfo.resolve(this.dataDirectory));
        answer.setPersistenceAdapter((PersistenceAdapter)pa);
        return answer;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        $assertionsDisabled = !ActiveMQContainerGBean.class.desiredAssertionStatus();
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder("ActiveMQ Message Broker", ActiveMQContainerGBean.class.getName());
        infoFactory.addReference("serverInfo", ServerInfo.class);
        infoFactory.addAttribute("brokerName", String.class, true);
        infoFactory.addAttribute("dataDirectory", String.class, true);
        infoFactory.addAttribute("BrokerContainer", BrokerContainer.class, false);
        infoFactory.setConstructor(new String[]{"serverInfo", "brokerName", "dataDirectory"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

