/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.util;

import java.net.URI;
import java.util.Map;
import junit.framework.TestCase;
import org.activemq.util.URIHelper;

public class URIHelperTest
extends TestCase {
    public void testQuery() throws Exception {
        URI uri = new URI("vm://localhost?syncSend=true&foo=bar");
        String query = uri.getQuery();
        URIHelperTest.assertEquals((String)"query", (String)"syncSend=true&foo=bar", (String)query);
        Map map = URIHelper.parseQuery((URI)uri);
        URIHelperTest.assertEquals((String)("map size: " + map), (int)2, (int)map.size());
        URIHelperTest.assertEquals((String)("map['syncSend'] for " + map), (Object)"true", map.get("syncSend"));
        URIHelperTest.assertEquals((String)("map['foo'] for " + map), (Object)"bar", map.get("foo"));
        uri = new URI("peer://development?syncSend=true&foo=bar");
        query = uri.getQuery();
        URIHelperTest.assertEquals((String)"query", (String)"syncSend=true&foo=bar", (String)query);
        uri = new URI("peer://(tcp://localhost:0?syncSend=false&foo=bar),tcp://localhost:223,?syncSend=true&foo=bar");
        query = URIHelper.getLastQuery((URI)uri);
        URIHelperTest.assertEquals((String)"query", (String)"syncSend=true&foo=bar", (String)query);
    }

    public void testNext() throws Exception {
        String addr1 = "tcp://localhost:6070";
        String addr2 = "tcp://localhost:6470";
        URIHelper helper = new URIHelper("(" + addr1 + "," + addr2 + ")");
        URIHelperTest.assertTrue((boolean)helper.hasNext());
        URIHelperTest.assertTrue((boolean)helper.getNext().equals(addr1));
        URIHelperTest.assertTrue((boolean)helper.hasNext());
        URIHelperTest.assertTrue((boolean)helper.getNext().equals(addr2));
        URIHelperTest.assertTrue((!helper.hasNext() ? 1 : 0) != 0);
    }

    public void testLastPath() throws Exception {
        String path = "testPath";
        String addr = "peer://tcp://localhost5067,tcp://localhost:67707/" + path + "?blob=rtt";
        URI uri = new URI(addr);
        URIHelperTest.assertTrue((boolean)URIHelper.getLastPath((URI)uri).equals(path));
        addr = "peer://tcp://localhost5067,tcp://localhost:67707/" + path;
        uri = new URI(addr);
        URIHelperTest.assertTrue((boolean)URIHelper.getLastPath((URI)uri).equals(path));
        addr = "peer://tcp://localhost5067,tcp://localhost:67707";
        uri = new URI(addr);
        URIHelperTest.assertTrue((URIHelper.getLastPath((URI)uri) == null ? 1 : 0) != 0);
        addr = "peer:///" + path;
        uri = new URI(addr);
        URIHelperTest.assertTrue((boolean)URIHelper.getLastPath((URI)uri).equals(path));
        addr = "peer:///";
        uri = new URI(addr);
        URIHelperTest.assertTrue((URIHelper.getLastPath((URI)uri) == null ? 1 : 0) != 0);
        addr = "vm://localhost";
        uri = new URI(addr);
        URIHelperTest.assertNull((Object)URIHelper.getLastPath((URI)uri));
        addr = "tcp://localhost:50607:/" + path;
        uri = new URI(addr);
        URIHelperTest.assertTrue((boolean)URIHelper.getLastPath((URI)uri).equals(path));
        addr = "reliable:tcp://localhost:61617/" + path;
        uri = new URI(addr);
        URIHelperTest.assertTrue((boolean)URIHelper.getLastPath((URI)uri).equals(path));
    }
}

