/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.util;

import java.util.Hashtable;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.activemq.util.IdGenerator;

public class IdGeneratorTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run((Class)IdGeneratorTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public IdGeneratorTest(String arg0) {
        super(arg0);
    }

    public void testGenerateId() {
        IdGenerator idGen = new IdGenerator();
        int count = 100000;
        Hashtable<String, String> table = new Hashtable<String, String>();
        String str = "";
        for (int i = 0; i < count; ++i) {
            str = idGen.generateId();
            IdGeneratorTest.assertTrue((str != null ? 1 : 0) != 0);
            IdGeneratorTest.assertTrue((table.get(str) == null ? 1 : 0) != 0);
            table.put(str, str);
        }
    }

    public void testGetSeedFromId() {
        IdGenerator idGen = new IdGenerator();
        String seed = idGen.getSeed();
        String id = idGen.generateId();
        String generatorId = IdGenerator.getSeedFromId((String)id);
        for (int i = 0; i < 1000; ++i) {
            IdGeneratorTest.assertTrue((boolean)generatorId.equals(seed));
        }
    }

    public void testGetCountFromId() {
        IdGenerator idGen = new IdGenerator();
        String seed = idGen.getSeed();
        for (int i = 0; i < 100; ++i) {
            String id = idGen.generateId();
            long count = IdGenerator.getCountFromId((String)id);
            IdGeneratorTest.assertTrue((count == (long)i ? 1 : 0) != 0);
        }
    }

    public void testCompare() {
        IdGenerator idGen = new IdGenerator();
        String seed = idGen.getSeed();
        String lastId = null;
        for (int i = 0; i < 100; ++i) {
            String id = idGen.generateId();
            if (lastId != null) {
                IdGeneratorTest.assertTrue((IdGenerator.compare((String)lastId, (String)id) == -1 ? 1 : 0) != 0);
            }
            lastId = id;
        }
    }
}

